/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import de.qfm.erp.common.request.role.RoleUpdateRequest;
import de.qfm.erp.common.response.role.RoleCommon;
import de.qfm.erp.common.response.role.RolePageCommon;
import de.qfm.erp.service.service.route.RoleRoute;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(description="Role Management Resource", name="RoleResource")
@OpenAPIDefinition(tags={@Tag(name="RoleResource", description="All Operations around Roles")})
@ApiResponses(value={@ApiResponse(responseCode="400", description="Something went wrong"), @ApiResponse(responseCode="403", description="Access denied"), @ApiResponse(responseCode="401", description="Expired or invalid JWT token")})
@RestController
@RequestMapping(value={"/api/v1/erp/roles"})
public class RoleResource {
    private static final Logger log = LogManager.getLogger(RoleResource.class);
    private final RoleRoute roleRoute;

    @Operation(summary="Paged Roles Listing")
    @GetMapping(value={"/"})
    public RolePageCommon list(@Parameter(description="The Page index starting at 0", example="0") @RequestParam(value="page", defaultValue="0") int page, @Parameter(description="The Page Size", example="1000") @RequestParam(value="size", defaultValue="1000") int size) {
        return this.roleRoute.page(page, size);
    }

    @Operation(summary="Role for Id")
    @GetMapping(value={"/{id}/"}, produces={"application/json"})
    public RoleCommon getById(@PathVariable(value="id") long id) {
        return this.roleRoute.byId(id);
    }

    @Operation(summary="Role by Name")
    @GetMapping(value={"/name={name}/"}, produces={"application/json"})
    public RoleCommon getByName(@PathVariable(value="name") String name) {
        return this.roleRoute.byName(name);
    }

    @Operation(summary="Create Role from Role Update Request")
    @PostMapping(value={"/"}, consumes={"application/json"}, produces={"application/json"})
    public RoleCommon createRole(@Parameter(description="Role Update Request", required=true) @Valid @RequestBody RoleUpdateRequest updateRequest) {
        return this.roleRoute.create(updateRequest);
    }

    @Operation(summary="Update a Role via RoleUpdate for Id")
    @PostMapping(value={"/{id}/"}, consumes={"application/json"}, produces={"application/json"})
    public RoleCommon updateRole(@PathVariable(value="id") long id, @Parameter(description="Role Update Request", required=true) @Valid @RequestBody RoleUpdateRequest updateRequest) {
        return this.roleRoute.update(id, updateRequest);
    }

    public RoleResource(RoleRoute roleRoute) {
        this.roleRoute = roleRoute;
    }
}

