/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import de.qfm.erp.common.request.project.ProjectUpdateRequest;
import de.qfm.erp.common.response.project.ProjectAutoCompleteResponse;
import de.qfm.erp.common.response.project.ProjectCommon;
import de.qfm.erp.common.response.project.ProjectPageCommon;
import de.qfm.erp.service.service.route.ProjectRoute;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(description="Project Management Resource", name="ProjectResource")
@OpenAPIDefinition(tags={@Tag(name="ProjectResource", description="All Operations around Projects")})
@ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully retrieved Entity / List", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="401", description="You are not authorized to view the resource", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="403", description="Accessing the resource you were trying to reach is forbidden", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="The resource you were trying to reach is not found", content={@Content(mediaType="application/json")})})
@RestController
@RequestMapping(value={"/api/v1/erp/projects"})
public class ProjectResource {
    private static final Logger log = LogManager.getLogger(ProjectResource.class);
    private final ProjectRoute route;

    @Operation(summary="Projects List / Paging")
    @GetMapping(value={"/"}, produces={"application/json"})
    public ProjectPageCommon list(@RequestParam(value="page", defaultValue="0") int page, @RequestParam(value="size", defaultValue="100") int size, @Parameter(description="Filter by 'any' Text", example="") @RequestParam(value="filter_text", defaultValue="") String filterText) {
        return this.route.page(page, size, StringUtils.trimToEmpty((String)filterText));
    }

    @Operation(summary="Projects by Id")
    @GetMapping(value={"/{id}/"}, produces={"application/json"})
    public ProjectCommon getById(@Parameter(description="Dictionary Item Id of the Entity to retrieve", required=true) @PathVariable(value="id") long id) {
        return this.route.byId(id);
    }

    @Operation(summary="Project AutoComplete")
    @GetMapping(value={"/_autocomplete/"}, produces={"application/json"})
    public ProjectAutoCompleteResponse autocomplete(@Parameter(description="filter autocomplete by text") @RequestParam(value="filter_text", defaultValue="") String filterText, @RequestParam(value="size", defaultValue="100") int size) {
        return this.route.standardAutoComplete(StringUtils.trimToEmpty((String)filterText), size);
    }

    @Operation(summary="Create Project from Project Update Request")
    @PostMapping(value={"/"}, consumes={"application/json"}, produces={"application/json"})
    public ProjectCommon createUser(@Parameter(description="Project Update Request", required=true) @Valid @RequestBody ProjectUpdateRequest updateRequest) {
        return this.route.create(updateRequest);
    }

    @Operation(summary="Update a Project via Project Update for Id")
    @PostMapping(value={"/{id}/"}, consumes={"application/json"}, produces={"application/json"})
    public ProjectCommon updateUser(@PathVariable(value="id") long id, @Parameter(description="Project Update Request", required=true) @Valid @RequestBody ProjectUpdateRequest updateRequest) {
        return this.route.update(id, updateRequest);
    }

    @Operation(summary="Delete Project")
    @DeleteMapping(value={"/{id}/"}, produces={"application/json"})
    public ProjectCommon disableUser(@PathVariable(value="id") long id) {
        return this.route.delete(id);
    }

    public ProjectResource(ProjectRoute route) {
        this.route = route;
    }
}

