/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import de.qfm.erp.common.response.role.PrivilegeListCommon;
import de.qfm.erp.service.service.route.PrivilegeRoute;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(description="Privilege Resource", name="PrivilegeResource")
@OpenAPIDefinition(tags={@Tag(name="PrivilegeResource", description="All Operations around Privileges")})
@ApiResponses(value={@ApiResponse(responseCode="400", description="Something went wrong"), @ApiResponse(responseCode="403", description="Access denied"), @ApiResponse(responseCode="401", description="Expired or invalid JWT token")})
@RestController
@RequestMapping(value={"/api/v1/erp/privileges"})
public class PrivilegeResource {
    private static final Logger log = LogManager.getLogger(PrivilegeResource.class);
    private final PrivilegeRoute route;

    @Operation(summary="Unpaged Privilege Listing")
    @GetMapping(value={"/"})
    public PrivilegeListCommon list() {
        return this.route.list();
    }

    public PrivilegeResource(PrivilegeRoute route) {
        this.route = route;
    }
}

