/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.service.service.MessageService;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(description="Messages Management Resource", name="MessagesResource")
@OpenAPIDefinition(tags={@Tag(name="MessagesResource", description="Debug Messages")})
@ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully retrieved Entity / List", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="401", description="You are not authorized to view the resource", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="403", description="Accessing the resource you were trying to reach is forbidden", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="The resource you were trying to reach is not found", content={@Content(mediaType="application/json")})})
@RestController
@RequestMapping(value={"/api/v1/erp/messages"})
public class MessagesResource {
    private static final Logger log = LogManager.getLogger(MessagesResource.class);
    private final MessageService messageService;

    @GetMapping(value={"/{key}/"})
    public String greeting(@PathVariable(value="key") String messageKeyCandidate) {
        Object[] params = new Object[]{"hello", "world"};
        EMessageKey messageKey = EMessageKey.lookup((String)messageKeyCandidate, (EMessageKey)EMessageKey.UNKNOWN);
        return this.messageService.get((Translatable)messageKey, params);
    }

    public MessagesResource(MessageService messageService) {
        this.messageService = messageService;
    }
}

