/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import de.qfm.erp.common.request.error.DecimalNumericRequest;
import de.qfm.erp.common.request.error.NotBlankRequest;
import de.qfm.erp.common.request.error.NotEmptyRequest;
import de.qfm.erp.common.request.error.NumericRequest;
import de.qfm.erp.common.request.error.SizeRequest;
import de.qfm.erp.common.response.error.ErrorResponse;
import de.qfm.erp.service.model.exception.request.RequestValidationException;
import de.qfm.erp.service.model.exception.request.ValueRangeException;
import de.qfm.erp.service.model.internal.fieldname.CascadedFieldName;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.math.BigDecimal;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(description="Error Resource", name="ErrorResource")
@OpenAPIDefinition(tags={@Tag(name="ErrorResource", description="All Operations around Errors")})
@RestController
@RequestMapping(value={"/api/v1/erp/errors"})
public class ErrorResource {
    private static final Logger log = LogManager.getLogger(ErrorResource.class);

    @Operation(summary="Default")
    @GetMapping(value={"/"})
    public ErrorResponse exampleExceptionHandler() {
        BigDecimal value = BigDecimal.valueOf(100.01);
        Range range = Range.closed((Comparable)BigDecimal.valueOf(1.5), (Comparable)BigDecimal.valueOf(99.5));
        CascadedFieldName fieldName = FieldNamesFactory.measurementPositionChild((int)10, (EField)EField.POSITION_FACTOR_1);
        String fieldPath = fieldName.path();
        String messageText = String.format("Field: %s has value: %s and is supposed to be in range: %s, Explain: Position Index: %s", fieldPath, value.toPlainString(), range, 10);
        Message message = Message.of((EMessageKey)EMessageKey.RANGE, (List)ImmutableList.of((Object)fieldPath, (Object)value, (Object)range, (Object)10));
        ImmutableList details = ImmutableList.of((Object)RequestValidationException.Detail.of((FieldName)fieldName, (Object)100, (String)messageText, (Message)message, (List)ImmutableList.of((Object)((BigDecimal)range.lowerEndpoint()).toPlainString(), (Object)((BigDecimal)range.upperEndpoint()).toPlainString())));
        throw new ValueRangeException("Positions contain Validation Errors", (List)details);
    }

    @Operation(summary="Invalid Param Test Endpoint")
    @PostMapping(value={"/_notempty/"}, consumes={"application/json"}, produces={"application/json"})
    public String notEmpty(@Valid @RequestBody NotEmptyRequest request) {
        return request.getValue();
    }

    @Operation(summary="Invalid Param Test Endpoint")
    @PostMapping(value={"/_notblank/"}, consumes={"application/json"}, produces={"application/json"})
    public String notBlank(@Valid @RequestBody NotBlankRequest request) {
        return request.getValue();
    }

    @Operation(summary="Invalid Param Test Endpoint")
    @PostMapping(value={"/_maxsize/"}, consumes={"application/json"}, produces={"application/json"})
    public String maxSize(@Valid @RequestBody SizeRequest request) {
        return request.getValue();
    }

    @Operation(summary="Invalid Number Test Endpoint")
    @PostMapping(value={"/_numeric/"}, consumes={"application/json"}, produces={"application/json"})
    public BigDecimal numeric(@Valid @RequestBody NumericRequest request) {
        return request.getValue();
    }

    @Operation(summary="Invalid Number Test Endpoint")
    @PostMapping(value={"/_decimalnumeric/"}, consumes={"application/json"}, produces={"application/json"})
    public BigDecimal numeric(@Valid @RequestBody DecimalNumericRequest request) {
        return request.getValue();
    }
}

