/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import com.google.common.collect.ImmutableList;
import de.leancoders.common.response.reporting.ReportResponse;
import de.qfm.erp.common.request.dashboard.DashboardFilterRequest;
import de.qfm.erp.common.response.dashboard.DashboardTableResponse;
import de.qfm.erp.common.response.dashboard.EDashboardKey;
import de.qfm.erp.common.response.quotation.StageFulfilmentDegreeSimpleCommon;
import de.qfm.erp.service.model.annotation.ProofOfConcept;
import de.qfm.erp.service.resource.AbstractResource;
import de.qfm.erp.service.service.route.DashboardRoute;
import de.qfm.erp.service.service.route.ReportingRoute;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(description="Dashboard (Management) Resource", name="DashboardResource")
@OpenAPIDefinition(tags={@Tag(name="DashboardResource", description="All Operations around the (personalized) Dashboard")})
@ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully retrieved Entity / List", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="401", description="You are not authorized to view the resource", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="403", description="Accessing the resource you were trying to reach is forbidden", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="The resource you were trying to reach is not found", content={@Content(mediaType="application/json")})})
@RestController
@RequestMapping(value={"/api/v1/erp/dashboards"})
public class DashboardResource {
    private static final Logger log = LogManager.getLogger(DashboardResource.class);
    private final DashboardRoute dashboardRoute;
    private final ReportingRoute reportingRoute;

    @Operation(summary="Hello World Endpoint", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=List.class))})})
    @GetMapping(value={"/"}, produces={"application/json"})
    public List<EDashboardKey> list() {
        return ImmutableList.copyOf((Object[])EDashboardKey.values());
    }

    @Operation(summary="Dashboard for Key")
    @GetMapping(value={"/{dashboardKeyCandidate}/"}, produces={"application/json"})
    public DashboardTableResponse dashboardByKey(@PathVariable(name="dashboardKeyCandidate") String dashboardKeyCandidate) {
        return this.dashboardRoute.byDashboardKeyCandidate(dashboardKeyCandidate, DashboardFilterRequest.EMPTY);
    }

    @Operation(summary="Dashboard for Key")
    @PostMapping(value={"/{dashboardKeyCandidate}/_xls/{groupKey}/"}, produces={"application/octet-stream"})
    public void dashboardByKeyFilteredXLS(@PathVariable(name="dashboardKeyCandidate") String dashboardKeyCandidate, @PathVariable(value="groupKey") String groupKeyCandidate, @Valid @RequestBody DashboardFilterRequest dashboardFilterRequest, HttpServletResponse response) throws IOException {
        Pair content = this.dashboardRoute.xlsByDashboardKeyCandidate(dashboardKeyCandidate, groupKeyCandidate, dashboardFilterRequest);
        AbstractResource.writeToStream((HttpServletResponse)response, (Pair)content, (String)"application/octet-stream");
    }

    @Operation(summary="Dashboard for Key")
    @PostMapping(value={"/{dashboardKeyCandidate}/"}, consumes={"application/json"}, produces={"application/json"})
    public DashboardTableResponse dashboardByKeyFiltered(@PathVariable(name="dashboardKeyCandidate") String dashboardKeyCandidate, @Valid @RequestBody DashboardFilterRequest dashboardFilterRequest) {
        return this.dashboardRoute.byDashboardKeyCandidate(dashboardKeyCandidate, dashboardFilterRequest);
    }

    @Operation(summary="Quotation Fulfilment Degree")
    @GetMapping(value={"/quotations/{id}/_degree_of_fulfilment/"}, produces={"application/json"})
    @ProofOfConcept(value="Quotation Fulfilment for Dashboards")
    public StageFulfilmentDegreeSimpleCommon dashboardByKey(@PathVariable(name="id") Long stageId) {
        return this.dashboardRoute.quotationFulfilmentDegree(stageId);
    }

    @Operation(summary="Report based on Report Type on actual Data")
    @GetMapping(value={"/reporting/{report}/"}, produces={"application/json"})
    public ReportResponse<?, ?> report(@PathVariable(value="report") String report, @RequestParam(value="limit", defaultValue="100") int limit) {
        return this.reportingRoute.reportResponse(report);
    }

    public DashboardResource(DashboardRoute dashboardRoute, ReportingRoute reportingRoute) {
        this.dashboardRoute = dashboardRoute;
        this.reportingRoute = reportingRoute;
    }
}

