/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import de.qfm.erp.common.response.businessunit.BusinessUnitsResponse;
import de.qfm.erp.common.response.businessunit.BusinessUnitsTreeResponse;
import de.qfm.erp.service.service.route.impl.BusinessUnitRoute;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(description="Business Unit Resource", name="BusinessUnitResource")
@OpenAPIDefinition(tags={@Tag(name="BusinessUnitResource", description="All Operations around Business Units")})
@ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully retrieved Entity / List"), @ApiResponse(responseCode="401", description="You are not authorized to view the resource"), @ApiResponse(responseCode="403", description="Accessing the resource you were trying to reach is forbidden"), @ApiResponse(responseCode="404", description="The resource you were trying to reach is not found")})
@RestController
@RequestMapping(value={"/api/v1/erp/business_units"})
public class BusinessUnitResource {
    private static final Logger log = LogManager.getLogger(BusinessUnitResource.class);
    private final BusinessUnitRoute route;

    @Operation(summary="Business Unit Listing Endpoint")
    @GetMapping(value={"/"})
    public BusinessUnitsResponse list(@Parameter(name="Include Deleted in the Response") @RequestParam(name="include_deleted", defaultValue="false") boolean includeDeleted) {
        return this.route.list(includeDeleted);
    }

    @Operation(summary="Business Unit Tree Endpoint")
    @GetMapping(value={"/{id}/_tree/"})
    public BusinessUnitsTreeResponse tree(@Parameter(name="The Id of the Top Business Unit", required=true) @PathVariable(value="id") long id, @Parameter(name="The Max Levels to Fetch", example="1", required=true) @RequestParam(name="max_levels", defaultValue="1") int maxLevels) {
        return this.route.tree(id, maxLevels);
    }

    public BusinessUnitResource(BusinessUnitRoute route) {
        this.route = route;
    }
}

