/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import de.qfm.erp.common.request.employee.attendance.AttendanceUpdateRequest;
import de.qfm.erp.common.response.employee.attendance.AttendanceCommon;
import de.qfm.erp.common.response.employee.attendance.AttendancesListCommon;
import de.qfm.erp.common.response.user.UserAutoCompleteResponse;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceOrigin;
import de.qfm.erp.service.resource.AbstractResource;
import de.qfm.erp.service.service.route.AutoCompleteRoute;
import de.qfm.erp.service.service.route.PayrollMonthRoute;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(description="Bad Weather Resource", name="BadWeatherResource")
@OpenAPIDefinition(tags={@Tag(name="BadWeatherResource", description="All Operations around Bad Weather Attendances")})
@ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully retrieved Entity / List", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="401", description="You are not authorized to view the resource", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="403", description="Accessing the resource you were trying to reach is forbidden", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="The resource you were trying to reach is not found", content={@Content(mediaType="application/json")})})
@RestController
@RequestMapping(value={"/api/v1/erp/attendances/"})
public class BadWeatherResource
extends AbstractResource {
    private static final Logger log = LogManager.getLogger(BadWeatherResource.class);
    private final AutoCompleteRoute autoCompleteRoute;
    private final PayrollMonthRoute payrollMonthRoute;

    @Operation(summary="List all (current) Attendances by YearMonth")
    @GetMapping(value={"/{year}/{month}/"}, produces={"application/json"})
    public AttendancesListCommon attendancesByMonth(@PathVariable(value="year") int year, @PathVariable(value="month") int month, @RequestParam(value="type", defaultValue="BAD_WEATHER") String type) {
        return this.payrollMonthRoute.attendancesByTypeAndYearAndMonth(type, year, month);
    }

    @Operation(summary="Retrieve current Attendance for User and Date")
    @GetMapping(value={"/{userId}/attendances/{date}/"}, produces={"application/json"})
    public AttendanceCommon attendanceByDay(@PathVariable(value="userId") long userId, @Parameter(name="date", description="Date in ISO date format that formats or parses a date without an offset", example="2011-12-03") @PathVariable(value="date") String date) {
        LocalDate localDate = LocalDate.parse(date, DateTimeFormatter.ISO_LOCAL_DATE);
        return this.payrollMonthRoute.attendanceByDay(EAttendanceOrigin.BAD_WEATHER, userId, localDate);
    }

    @Operation(summary="Retrieve current 'allowed' Users (with disabled flag) for Bad Weather for provided Date")
    @GetMapping(value={"/{date}/_autocomplete/"}, produces={"application/json"})
    public UserAutoCompleteResponse badWeatherUsers(@Parameter(name="date", description="Date in ISO date format that formats or parses a date without an offset", example="2011-12-03") @PathVariable(value="date") String date, @Parameter(description="Filter by 'any' Text", example="") @RequestParam(value="filter_text", defaultValue="") String filterText) {
        LocalDate localDate = LocalDate.parse(date, DateTimeFormatter.ISO_LOCAL_DATE);
        return this.autoCompleteRoute.badWeatherAutoComplete(localDate, filterText);
    }

    @Operation(summary="RESET Attendance by Id")
    @DeleteMapping(value={"/{id}/"}, produces={"application/json"})
    public AttendanceCommon attendanceByDay(@PathVariable(value="id") long attendanceId) {
        return this.payrollMonthRoute.resetAttendance(EAttendanceOrigin.BAD_WEATHER, attendanceId);
    }

    @Operation(summary="Updates Attendance by Id")
    @PostMapping(value={"/{id}/"}, consumes={"application/json"}, produces={"application/json"})
    public AttendanceCommon attendanceByDay(@PathVariable(value="id") long attendanceId, @RequestBody @Valid AttendanceUpdateRequest attendanceUpdateRequest) {
        return this.payrollMonthRoute.update(EAttendanceOrigin.BAD_WEATHER, attendanceId, attendanceUpdateRequest);
    }

    @Operation(summary="List all (current) Attendances by YearMonth")
    @GetMapping(value={"/{year}/{month}/_print/"}, produces={"application/pdf"})
    public void attendancesByMonth(@PathVariable(value="year") int year, @PathVariable(value="month") int month, @RequestParam(value="type", defaultValue="BAD_WEATHER_REPORT") String type, @NonNull HttpServletResponse response) throws IOException {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
    }

    public BadWeatherResource(AutoCompleteRoute autoCompleteRoute, PayrollMonthRoute payrollMonthRoute) {
        this.autoCompleteRoute = autoCompleteRoute;
        this.payrollMonthRoute = payrollMonthRoute;
    }
}

