/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import com.google.common.base.CharMatcher;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractResource {
    static final CharMatcher ALLOWED_FILE_CHAR = CharMatcher.inRange((char)'0', (char)'9').or(CharMatcher.inRange((char)'a', (char)'z')).or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.anyOf((CharSequence)".-")).precomputed();

    protected static void writeToStream(@NonNull HttpServletResponse response, @NonNull Pair<String, byte[]> content, @NonNull String contentType) throws IOException {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        if (contentType == null) {
            throw new NullPointerException("contentType is marked non-null but is null");
        }
        ServletOutputStream outputStream = response.getOutputStream();
        String name = (String)content.getLeft();
        byte[] contents = (byte[])content.getRight();
        String cleanedFileName = ALLOWED_FILE_CHAR.negate().replaceFrom((CharSequence)name, (CharSequence)"_");
        response.setContentType(contentType);
        response.setHeader("Content-Disposition", String.format("inline; filename=%s", cleanedFileName));
        response.setContentLength(contents.length);
        outputStream.write(contents);
        outputStream.flush();
        outputStream.close();
    }
}

