/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.repository;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import de.qfm.erp.service.model.internal.dashboard.IReportCountStringLong;
import de.qfm.erp.service.model.jpa.search.ESearchIndexState;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.repository.BaseRepository;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface UserRepository
extends JpaRepository<User, Long>,
JpaSpecificationExecutor<User> {
    public static final Splitter SEARCH_SPLITTER = Splitter.on((char)' ').omitEmptyStrings();

    @Nonnull
    public static Specification<User> filter(@NonNull String text, @NonNull Range<LocalDate> referenceDateRange, boolean considerContract, boolean truncDates) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (referenceDateRange == null) {
            throw new NullPointerException("referenceDateRange is marked non-null but is null");
        }
        return (Specification & Serializable)(root, criteria, builder) -> {
            ArrayList predicates = Lists.newArrayList();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{text})) {
                ImmutableList terms = ImmutableList.copyOf(SEARCH_SPLITTER.split((CharSequence)text).iterator());
                for (String term : terms) {
                    String lowerTerm = StringUtils.lowerCase((String)term);
                    if (StringUtils.isNumeric((CharSequence)lowerTerm)) {
                        predicates.add(builder.or((Expression)builder.like(root.get("personalNumber").as(String.class), "%" + lowerTerm + "%"), (Expression)builder.like(root.get("squadNumber").as(String.class), "%" + lowerTerm + "%")));
                        continue;
                    }
                    predicates.add(builder.or(new Predicate[]{builder.like(builder.lower((Expression)root.get("firstName")), "%" + lowerTerm + "%"), builder.like(builder.lower((Expression)root.get("lastName")), "%" + lowerTerm + "%"), builder.like(builder.lower((Expression)root.get("fullName")), "%" + lowerTerm + "%")}));
                }
            }
            if (!referenceDateRange.equals((Object)Range.all())) {
                LocalDate lowerEndpoint = referenceDateRange.hasLowerBound() ? (LocalDate)referenceDateRange.lowerEndpoint() : LocalDate.of(1900, 1, 1);
                LocalDate upperEndpoint = referenceDateRange.hasUpperBound() ? (LocalDate)referenceDateRange.upperEndpoint() : LocalDate.of(2100, 12, 1);
                LocalDate dateRangeFrom = truncDates ? lowerEndpoint.withDayOfMonth(1) : lowerEndpoint;
                LocalDate dateRangeTo = truncDates ? upperEndpoint.withDayOfMonth(1) : upperEndpoint;
                Join userCC = root.join("userCostCenters");
                Path validBeginPathCC = truncDates ? BaseRepository.truncToMonth((CriteriaBuilder)builder, (Path)userCC.get("validBegin")) : userCC.get("validBegin");
                Path validEndPathCC = truncDates ? BaseRepository.truncToMonth((CriteriaBuilder)builder, (Path)userCC.get("validEnd")) : userCC.get("validEnd");
                predicates.add(builder.and((Expression)builder.lessThanOrEqualTo((Expression)validBeginPathCC, (Comparable)dateRangeTo), (Expression)builder.greaterThanOrEqualTo((Expression)validEndPathCC, (Comparable)dateRangeFrom)));
                if (considerContract) {
                    Join userEC = root.join("employeeContracts");
                    Path validBeginPathEC = userEC.get("validBegin");
                    Path validEndPathEC = userEC.get("validEnd");
                    predicates.add(builder.and((Expression)builder.lessThanOrEqualTo(BaseRepository.truncToMonth((CriteriaBuilder)builder, (Path)validBeginPathEC), (Comparable)dateRangeTo), (Expression)builder.greaterThanOrEqualTo(BaseRepository.truncToMonth((CriteriaBuilder)builder, (Path)validEndPathEC), (Comparable)dateRangeFrom)));
                }
            }
            criteria.distinct(true);
            return builder.and(predicates.toArray(new Predicate[0]));
        };
    }

    @Nonnull
    public Optional<User> findOneByUsernameIgnoreCaseAndIdNot(@NonNull String var1, @NonNull Long var2);

    @Nonnull
    public Optional<User> findOneByUsernameIgnoreCase(@NonNull String var1);

    @Nonnull
    public Optional<User> findOneByReferenceId(@NonNull String var1);

    @Nonnull
    public Optional<User> findOneByFlagSyncDefault(boolean var1);

    @Nonnull
    public List<User> findAllByReferenceIdIn(@NonNull Iterable<String> var1);

    @Nonnull
    public List<User> findAllByDisableDateLessThanEqual(@NonNull LocalDate var1);

    @Nonnull
    public Optional<User> findOneByPersonalNumberAndIdNot(@NonNull Integer var1, @NonNull Long var2);

    @Nonnull
    public Optional<User> findOneByPersonalNumber(@NonNull Integer var1);

    @Query(value="select u from User u join u.userCostCenters uc where   trunc(uc.validBegin, MONTH) <= :referenceDate  AND trunc(uc.validEnd, MONTH) >= :referenceDate  AND uc.costCenter = :costCenter")
    @Nonnull
    public Iterable<User> usersInCostCenterEQ(@Param(value="referenceDate") @NonNull LocalDate var1, @Param(value="costCenter") @NonNull String var2);

    @Query(value="select u from User u join u.userCostCenters uc where   trunc(uc.validBegin, MONTH) <= :referenceDate  AND  trunc(uc.validEnd, MONTH) >= :referenceDate  AND uc.costCenter like :costCenter%")
    @Nonnull
    public Iterable<User> usersInCostCenterStartWith(@Param(value="referenceDate") @NonNull LocalDate var1, @Param(value="costCenter") @NonNull String var2);

    @Query(value="select uc.costCenter as label, count(uc.costCenter) as amount from User u join u.userCostCenters uc where    trunc(uc.validBegin, MONTH) <= :referenceDate AND trunc(uc.validEnd, MONTH) >= :referenceDate group by    uc.costCenter")
    @Nonnull
    public Iterable<IReportCountStringLong> usersPerCostCenter(LocalDate var1);

    @Query(value="select u from User u join u.userCostCenters uc where   uc.validBegin <= :referenceDate  AND uc.validEnd >= :referenceDate  AND uc.flagLead = true  AND uc.costCenter = :costCenter")
    @Nonnull
    public Iterable<User> managersInCostCenter(@Param(value="referenceDate") @NonNull LocalDate var1, @Param(value="costCenter") @NonNull String var2);

    public Page<User> findAll(@NonNull Specification<User> var1, @NonNull Pageable var2);

    @Query(value="SELECT u FROM User u WHERE   u.searchIndexState in :searchIndexStates")
    @Nonnull
    public List<User> findAllUnIndexed(@Param(value="searchIndexStates") @NonNull Iterable<ESearchIndexState> var1, @NonNull Pageable var2);

    @Modifying
    @Query(value="update User u set u.searchIndexState = :searchIndexState where u.id in :userIds")
    public int updateSearchIndexState(@Param(value="searchIndexState") @NonNull ESearchIndexState var1, @Param(value="userIds") @NonNull Iterable<Long> var2);
}

