/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.repository;

import de.qfm.erp.service.model.jpa.invoice.EInvoiceType;
import de.qfm.erp.service.model.jpa.invoice.TaxKey;
import java.math.BigDecimal;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface TaxKeyRepository
extends JpaRepository<TaxKey, Long> {
    @Nonnull
    @Query(value="select tk from TaxKey tk where tk.invoiceType = :invoiceType and tk.flagSubContractorAsExternalServiceAccounting = :flagSubContractorAsExternalServiceAccountingOrder and tk.flagCompanyGroup = :flagCompanyGroup order by tk.id asc ")
    public Page<TaxKey> findAllByInvoiceTypeAndFlagsOrderById(@NonNull Pageable var1, @Param(value="invoiceType") @NonNull EInvoiceType var2, @Param(value="flagSubContractorAsExternalServiceAccountingOrder") boolean var3, @Param(value="flagCompanyGroup") boolean var4);

    @Nonnull
    default public Optional<TaxKey> findFirstByInvoiceTypeAndVat(@NonNull EInvoiceType invoiceType, @NonNull BigDecimal vat, boolean flagSubContractorAsExternalServiceAccounting, boolean flagCompanyGroup) {
        if (invoiceType == null) {
            throw new NullPointerException("invoiceType is marked non-null but is null");
        }
        if (vat == null) {
            throw new NullPointerException("vat is marked non-null but is null");
        }
        Page page = this.findByInvoiceTypeAndVat(invoiceType, vat, flagSubContractorAsExternalServiceAccounting, flagCompanyGroup, (Pageable)PageRequest.of((int)0, (int)1, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"})));
        if (page.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((TaxKey)page.getContent().get(0));
    }

    @Query(value="select t from TaxKey t where t.invoiceType = :invoiceType AND  t.vat = :vat AND  t.flagSubContractorAsExternalServiceAccounting = :flagSubContractorAsExternalServiceAccounting AND  t.flagCompanyGroup = :flagCompanyGroup ")
    @Nonnull
    public Page<TaxKey> findByInvoiceTypeAndVat(@Param(value="invoiceType") @NonNull EInvoiceType var1, @Param(value="vat") @NonNull BigDecimal var2, @Param(value="flagSubContractorAsExternalServiceAccounting") boolean var3, @Param(value="flagCompanyGroup") boolean var4, @NonNull Pageable var5);
}

