/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.repository;

import de.qfm.erp.service.model.jpa.invoice.EInvoiceExportState;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceState;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceType;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.model.jpa.invoice.TaxKey;
import de.qfm.erp.service.model.jpa.search.ESearchIndexState;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.repository.BaseRepository;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface InvoiceRepository
extends JpaRepository<Invoice, Long>,
JpaSpecificationExecutor<Invoice>,
BaseRepository {
    @Nonnull
    public Integer countByFinanceTaxKey(@NonNull TaxKey var1);

    @Query(value="select max(i.sequentialNumber) from Invoice i join i.quotation q where   q.quotationNumber in (:quotationNumber)   AND   i.invoiceState in (:invoiceStates) ")
    @Nullable
    public Integer currentSequentialNumber(@Param(value="quotationNumber") @NonNull Set<String> var1, @Param(value="invoiceStates") @NonNull Set<EInvoiceState> var2);

    @Query(value="select max(i.internalPartialNumber) from Invoice i join i.quotation q where   q.quotationNumber in (:quotationNumber)   AND   i.invoiceType in (:invoiceTypes)   AND   i.invoiceState in (:invoiceStates) ")
    @Nullable
    public Integer currentPartialNumber(@Param(value="quotationNumber") @NonNull Set<String> var1, @Param(value="invoiceTypes") @NonNull Set<EInvoiceType> var2, @Param(value="invoiceStates") @NonNull Set<EInvoiceState> var3);

    @Query(value="select max(i.internalPartialFinalNumber) from Invoice i join i.quotation q where   q.quotationNumber in (:quotationNumber)   AND   i.invoiceType in (:invoiceTypes)   AND   i.invoiceState in (:invoiceStates) ")
    @Nullable
    public Integer currentPartialFinalNumber(@Param(value="quotationNumber") @NonNull Set<String> var1, @Param(value="invoiceTypes") @NonNull Set<EInvoiceType> var2, @Param(value="invoiceStates") @NonNull Set<EInvoiceState> var3);

    @Query(value="select i from Invoice i where   i.dmsExportState in (:dmsExportState)   AND   i.invoiceType in (:invoiceTypes)   AND   i.invoiceState in (:invoiceStates) ")
    @Nonnull
    public List<Invoice> notExportedToDMS(@Param(value="dmsExportState") @NonNull Set<EInvoiceExportState> var1, @Param(value="invoiceTypes") @NonNull Set<EInvoiceType> var2, @Param(value="invoiceStates") @NonNull Set<EInvoiceState> var3, @NonNull Pageable var4);

    @Query(value="select i from Invoice i  join i.invoiceAddress a  join a.customer c where   c.flagCompanyGroup = true   AND   i.dmsCompanyGroupExportState in (:dmsCompanyGroupExportState)   AND   i.invoiceType in (:invoiceTypes)   AND   i.invoiceState in (:invoiceStates) ")
    @Nonnull
    public List<Invoice> notExportedToDMSCompanyGroup(@Param(value="dmsCompanyGroupExportState") @NonNull Set<EInvoiceExportState> var1, @Param(value="invoiceTypes") @NonNull Set<EInvoiceType> var2, @Param(value="invoiceStates") @NonNull Set<EInvoiceState> var3, @NonNull Pageable var4);

    @Query(value="select i from Invoice i where   i.fileStoreExportState in (:dmsExportState)   AND   i.invoiceType in (:invoiceTypes)   AND   i.invoiceState in (:invoiceStates) ")
    @Nonnull
    public List<Invoice> notExportedToStore(@Param(value="dmsExportState") @NonNull Set<EInvoiceExportState> var1, @Param(value="invoiceTypes") @NonNull Set<EInvoiceType> var2, @Param(value="invoiceStates") @NonNull Set<EInvoiceState> var3, @NonNull Pageable var4);

    @Query(value="select   max(to_number(substr(a.invoice_number, 5, 5)) - 1) from   invoice a where   a.invoice_number like :invoicePrefix   and to_number(substr(a.invoice_number, 5, 5)) > 1   and not exists(     select '*'     from invoice b     where b.invoice_number = substr(a.invoice_number, 1, 4) || lpad(to_char(to_number(substr(a.invoice_number, 5, 5)) - 1), 5, '0')   )", nativeQuery=true)
    @Nonnull
    public Optional<Long> findHolesWithPrefixLength1(@Param(value="invoicePrefix") @NonNull String var1);

    @Query(value="select   max(to_number(substr(a.invoice_number, 6, 5)) - 1) from   invoice a where  a.invoice_number like :invoicePrefix   and to_number(substr(a.invoice_number, 6, 5)) > 1   and not exists(     select '*'     from invoice b     where b.invoice_number = substr(a.invoice_number, 1, 5) || lpad(to_char(to_number(substr(a.invoice_number, 6, 5)) - 1), 5, '0'))", nativeQuery=true)
    @Nonnull
    public Optional<Long> findHolesWithPrefixLength2(@Param(value="invoicePrefix") @NonNull String var1);

    @Nonnull
    public Optional<Invoice> findByInvoiceNumber(@NonNull String var1);

    @Query(value="SELECT i FROM Invoice i WHERE   i.searchIndexState in :searchIndexStates")
    @Nonnull
    public List<Invoice> findAllUnIndexed(@Param(value="searchIndexStates") @NonNull Iterable<ESearchIndexState> var1, @NonNull Pageable var2);

    @Modifying
    @Query(value="update Invoice i set i.searchIndexState = :searchIndexState where i.id in :invoiceIds")
    public int updateSearchIndexState(@Param(value="searchIndexState") @NonNull ESearchIndexState var1, @Param(value="invoiceIds") @NonNull Iterable<Long> var2);

    @Modifying
    @Query(value="update Invoice i  set i.dmsExportedOn = :dmsExportedOn, i.dmsExportedBy = :dmsExportedBy, i.dmsExportedToPath = :dmsExportedToPath,  i.dmsExportedValue = :dmsExportedValue,  i.dmsExportState = :dmsExportState  where i.id = :invoiceId")
    public void patchDMSStore(@Param(value="invoiceId") long var1, @Param(value="dmsExportedOn") LocalDateTime var3, @Param(value="dmsExportedBy") User var4, @Param(value="dmsExportedToPath") String var5, @Param(value="dmsExportedValue") BigDecimal var6, @Param(value="dmsExportState") EInvoiceExportState var7);

    @Modifying
    @Query(value="update Invoice i  set i.fileStoreExportedOn = :fileStoreExportedOn, i.fileStoreExportedToPath = :fileStoreExportedToPath,  i.fileStoreExportState = :fileStoreExportState  where i.id = :invoiceId")
    public void patchFileStore(@Param(value="invoiceId") long var1, @Param(value="fileStoreExportedOn") LocalDateTime var3, @Param(value="fileStoreExportedToPath") String var4, @Param(value="fileStoreExportState") EInvoiceExportState var5);
}

