/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.search;

import de.qfm.erp.service.model.search.InternalSearchRequest;
import de.qfm.erp.service.model.search.SearchResultItem;
import de.qfm.erp.service.model.search.timing.TimingResult;
import java.util.List;
import lombok.NonNull;

public abstract class IndexSearchResult<V extends SearchResultItem> {
    @NonNull
    private final InternalSearchRequest searchRequest;
    private final long totalHits;
    private final int totalPages;
    @NonNull
    private final List<V> items;
    @NonNull
    private final TimingResult timing;

    protected IndexSearchResult(@NonNull InternalSearchRequest searchRequest, long totalHits, int totalPages, @NonNull List<V> items, @NonNull TimingResult timing) {
        if (searchRequest == null) {
            throw new NullPointerException("searchRequest is marked non-null but is null");
        }
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        if (timing == null) {
            throw new NullPointerException("timing is marked non-null but is null");
        }
        this.searchRequest = searchRequest;
        this.totalHits = totalHits;
        this.totalPages = totalPages;
        this.items = items;
        this.timing = timing;
    }

    @NonNull
    public InternalSearchRequest getSearchRequest() {
        return this.searchRequest;
    }

    public long getTotalHits() {
        return this.totalHits;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    @NonNull
    public List<V> getItems() {
        return this.items;
    }

    @NonNull
    public TimingResult getTiming() {
        return this.timing;
    }

    public String toString() {
        return "IndexSearchResult(searchRequest=" + String.valueOf(this.getSearchRequest()) + ", totalHits=" + this.getTotalHits() + ", totalPages=" + this.getTotalPages() + ", items=" + String.valueOf(this.getItems()) + ", timing=" + String.valueOf(this.getTiming()) + ")";
    }
}

