/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.quotation;

import de.qfm.erp.service.helper.NullStringConverter;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.project.SubProject;
import de.qfm.erp.service.model.jpa.quotation.EQEntityState;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.search.ESearchIndexState;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.util.Set;
import org.hibernate.annotations.Formula;

@Entity(name="QEntity")
@Table(name="Q_ENTITY")
public class QEntity
extends EntityBase {
    private static final String SEQUENCE_NAME = "Q_ENTITY_SEQ";
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="Q_ENTITY_SEQ")
    @SequenceGenerator(sequenceName="Q_ENTITY_SEQ", allocationSize=1, name="Q_ENTITY_SEQ")
    private Long id;
    @Convert(converter=NullStringConverter.class)
    @Column(name="q_number", length=50)
    private String qNumber;
    @Convert(converter=NullStringConverter.class)
    @Column(name="alias", length=250)
    private String alias;
    @Formula(value="coalesce('INQUIRY_TEMPORARY', 0,'INQUIRY_NOTIFIED', 1,'INQUIRY_ARCHIVED', 2,'CALCULATION_TEMPORARY', 3,'CALCULATION_ARCHIVED', 4,'QUOTATION_TEMPORARY', 5,'QUOTATION_SUBMITTED', 6,'QUOTATION_APPROVED', 7,'QUOTATION_DESIGNATED_COMMISSION', 8,'QUOTATION_ARCHIVED', 9,'COMMISSION_TEMPORARY', 10,'COMMISSION_ACTIVE', 11,'COMMISSION_EXPIRING', 12,'COMMISSION_CLOSED', 13,'COMMISSION_REWORK', 14,'COMMISSION_ARCHIVED', 15,0)")
    @Enumerated(value=EnumType.STRING)
    @Column(name="q_entity_state", length=50)
    private EQEntityState qEntityState;
    @Column(name="absolute_client_home_folder")
    private String absoluteClientHomeFolder;
    @Column(name="absolute_server_home_folder")
    private String absoluteServerHomeFolder;
    @Column(name="search_index_state", length=50)
    @Enumerated(value=EnumType.STRING)
    private ESearchIndexState searchIndexState;
    @Convert(converter=NullStringConverter.class)
    @Column(name="remarks_inquiry")
    private String remarksInquiry;
    @Convert(converter=NullStringConverter.class)
    @Column(name="remarks_calculation")
    private String remarksCalculation;
    @Convert(converter=NullStringConverter.class)
    @Column(name="remarks_quotation")
    private String remarksQuotation;
    @Convert(converter=NullStringConverter.class)
    @Column(name="remarks_commission")
    private String remarksCommission;
    @Convert(converter=NullStringConverter.class)
    @Column(name="remarks_addendum")
    private String remarksAddendum;
    @Convert(converter=NullStringConverter.class)
    @Column(name="remarks_cost_estimate")
    private String remarksCostEstimate;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="primary_stage_id")
    private Quotation primaryStage;
    @OneToMany(mappedBy="qEntity")
    private Set<Quotation> stages;
    @OneToMany(mappedBy="qEntity")
    private Set<SubProject> subProjects;

    public Long getId() {
        return this.id;
    }

    public String getQNumber() {
        return this.qNumber;
    }

    public String getAlias() {
        return this.alias;
    }

    public EQEntityState getQEntityState() {
        return this.qEntityState;
    }

    public String getAbsoluteClientHomeFolder() {
        return this.absoluteClientHomeFolder;
    }

    public String getAbsoluteServerHomeFolder() {
        return this.absoluteServerHomeFolder;
    }

    public ESearchIndexState getSearchIndexState() {
        return this.searchIndexState;
    }

    public String getRemarksInquiry() {
        return this.remarksInquiry;
    }

    public String getRemarksCalculation() {
        return this.remarksCalculation;
    }

    public String getRemarksQuotation() {
        return this.remarksQuotation;
    }

    public String getRemarksCommission() {
        return this.remarksCommission;
    }

    public String getRemarksAddendum() {
        return this.remarksAddendum;
    }

    public String getRemarksCostEstimate() {
        return this.remarksCostEstimate;
    }

    public Quotation getPrimaryStage() {
        return this.primaryStage;
    }

    public Set<Quotation> getStages() {
        return this.stages;
    }

    public Set<SubProject> getSubProjects() {
        return this.subProjects;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setQNumber(String qNumber) {
        this.qNumber = qNumber;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setQEntityState(EQEntityState qEntityState) {
        this.qEntityState = qEntityState;
    }

    public void setAbsoluteClientHomeFolder(String absoluteClientHomeFolder) {
        this.absoluteClientHomeFolder = absoluteClientHomeFolder;
    }

    public void setAbsoluteServerHomeFolder(String absoluteServerHomeFolder) {
        this.absoluteServerHomeFolder = absoluteServerHomeFolder;
    }

    public void setSearchIndexState(ESearchIndexState searchIndexState) {
        this.searchIndexState = searchIndexState;
    }

    public void setRemarksInquiry(String remarksInquiry) {
        this.remarksInquiry = remarksInquiry;
    }

    public void setRemarksCalculation(String remarksCalculation) {
        this.remarksCalculation = remarksCalculation;
    }

    public void setRemarksQuotation(String remarksQuotation) {
        this.remarksQuotation = remarksQuotation;
    }

    public void setRemarksCommission(String remarksCommission) {
        this.remarksCommission = remarksCommission;
    }

    public void setRemarksAddendum(String remarksAddendum) {
        this.remarksAddendum = remarksAddendum;
    }

    public void setRemarksCostEstimate(String remarksCostEstimate) {
        this.remarksCostEstimate = remarksCostEstimate;
    }

    public void setPrimaryStage(Quotation primaryStage) {
        this.primaryStage = primaryStage;
    }

    public void setStages(Set<Quotation> stages) {
        this.stages = stages;
    }

    public void setSubProjects(Set<SubProject> subProjects) {
        this.subProjects = subProjects;
    }

    public String toString() {
        return "QEntity(super=" + super.toString() + ", id=" + this.getId() + ", qNumber=" + this.getQNumber() + ", alias=" + this.getAlias() + ", qEntityState=" + String.valueOf(this.getQEntityState()) + ", absoluteClientHomeFolder=" + this.getAbsoluteClientHomeFolder() + ", absoluteServerHomeFolder=" + this.getAbsoluteServerHomeFolder() + ", searchIndexState=" + String.valueOf(this.getSearchIndexState()) + ", remarksInquiry=" + this.getRemarksInquiry() + ", remarksCalculation=" + this.getRemarksCalculation() + ", remarksQuotation=" + this.getRemarksQuotation() + ", remarksCommission=" + this.getRemarksCommission() + ", remarksAddendum=" + this.getRemarksAddendum() + ", remarksCostEstimate=" + this.getRemarksCostEstimate() + ")";
    }
}

