/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.quotation;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EInquiryType {
    UNKNOWN,
    DIRECT_CUSTOMER_INQUIRY,
    FREE_ASSIGNMENT,
    INTERNAL,
    PUBLIC_TENDER,
    LIMITED_TENDER,
    PUBLIC_PARTICIPANT_COMPETITION,
    OTHER;

    private static final Map<String, EInquiryType> LOOKUP;

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EInquiryType lookup(@NonNull String candidate, @NonNull EInquiryType defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EInquiryType.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EInquiryType> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EInquiryType.key((String)candidate);
        return Optional.ofNullable((EInquiryType)LOOKUP.get(key));
    }

    @Nonnull
    private static String key(@NonNull EInquiryType item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return EInquiryType.key((String)item.name());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EInquiryType value : EInquiryType.values()) {
            String key = EInquiryType.key((EInquiryType)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
    }
}

