/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.measurement;

import de.qfm.erp.service.helper.NullStringConverter;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.PssReleaseOrder;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.util.Objects;
import org.hibernate.Hibernate;

@Entity(name="ReleaseOrder")
@Table(name="RELEASE_ORDER")
public class ReleaseOrder
extends EntityBase {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="RELEASE_ORDER_SEQ")
    @SequenceGenerator(sequenceName="RELEASE_ORDER_SEQ", allocationSize=1, name="RELEASE_ORDER_SEQ")
    private Long id;
    @Column(name="reference_id", length=50)
    private String referenceId;
    @Convert(converter=NullStringConverter.class)
    @Column(name="name", length=250)
    private String name;
    @Convert(converter=NullStringConverter.class)
    @Column(name="order_number", length=13)
    private String orderNumber;
    @Deprecated(forRemoval=true)
    @Convert(converter=NullStringConverter.class)
    @Column(name="quotation_number", length=250)
    private String quotationNumber;
    @JoinColumn(name="pss_release_order_id")
    @OneToOne(fetch=FetchType.EAGER)
    private PssReleaseOrder pssReleaseOrder;
    @JoinColumn(name="measurement_id")
    @OneToOne(fetch=FetchType.LAZY)
    private Measurement measurement;
    @JoinColumn(name="quotation_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private Quotation quotation;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass((Object)this) != Hibernate.getClass((Object)o)) {
            return false;
        }
        ReleaseOrder that = (ReleaseOrder)o;
        return this.id != null && Objects.equals(this.id, that.getId());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public Long getId() {
        return this.id;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public String getName() {
        return this.name;
    }

    public String getOrderNumber() {
        return this.orderNumber;
    }

    @Deprecated
    public String getQuotationNumber() {
        return this.quotationNumber;
    }

    public PssReleaseOrder getPssReleaseOrder() {
        return this.pssReleaseOrder;
    }

    public Measurement getMeasurement() {
        return this.measurement;
    }

    public Quotation getQuotation() {
        return this.quotation;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    @Deprecated
    public void setQuotationNumber(String quotationNumber) {
        this.quotationNumber = quotationNumber;
    }

    public void setPssReleaseOrder(PssReleaseOrder pssReleaseOrder) {
        this.pssReleaseOrder = pssReleaseOrder;
    }

    public void setMeasurement(Measurement measurement) {
        this.measurement = measurement;
    }

    public void setQuotation(Quotation quotation) {
        this.quotation = quotation;
    }

    public String toString() {
        return "ReleaseOrder(super=" + super.toString() + ", id=" + this.getId() + ", referenceId=" + this.getReferenceId() + ", name=" + this.getName() + ", orderNumber=" + this.getOrderNumber() + ", quotationNumber=" + this.getQuotationNumber() + ")";
    }
}

