/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.invoice;

import de.qfm.erp.service.helper.NullStringConverter;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.customer.Address;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceExportState;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceSource;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceState;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceType;
import de.qfm.erp.service.model.jpa.invoice.InvoiceAddendumDiscount;
import de.qfm.erp.service.model.jpa.invoice.InvoiceAttachment;
import de.qfm.erp.service.model.jpa.invoice.InvoicePosition;
import de.qfm.erp.service.model.jpa.invoice.InvoiceSupplement;
import de.qfm.erp.service.model.jpa.invoice.TaxKey;
import de.qfm.erp.service.model.jpa.measurement.InvoiceMeasurement;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.search.ESearchIndexState;
import de.qfm.erp.service.model.jpa.user.User;
import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Set;
import org.hibernate.Hibernate;

@Entity(name="Invoice")
@Table(name="INVOICE")
public class Invoice
extends EntityBase {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="INVOICE_SEQ")
    @SequenceGenerator(sequenceName="INVOICE_SEQ", allocationSize=1, name="INVOICE_SEQ")
    @Access(value=AccessType.PROPERTY)
    private Long id;
    @Convert(converter=NullStringConverter.class)
    @Column(name="reference_id", length=50)
    private String referenceId;
    @Enumerated(value=EnumType.STRING)
    @Column(name="invoice_source", length=50)
    private EInvoiceSource invoiceSource;
    @Column(name="search_index_state", length=50)
    @Enumerated(value=EnumType.STRING)
    private ESearchIndexState searchIndexState;
    @Column(name="invoice_state_on")
    private LocalDateTime invoiceStateSince;
    @Enumerated(value=EnumType.STRING)
    @Column(name="invoice_state", length=50)
    private EInvoiceState invoiceState;
    @JoinColumn(name="quotation_id")
    @ManyToOne(optional=true)
    private Quotation quotation;
    @Convert(converter=NullStringConverter.class)
    @Column(name="invoice_number", length=50, unique=true)
    private String invoiceNumber;
    @Column(name="sequential_number")
    private Integer sequentialNumber;
    @Column(name="internal_partial_number")
    private Integer internalPartialNumber;
    @Column(name="internal_partial_final_number")
    private Integer internalPartialFinalNumber;
    @Deprecated(forRemoval=true)
    @Column(name="cumulative_number")
    private Integer cumulativeNumber;
    @Convert(converter=NullStringConverter.class)
    @Column(name="payment_conditions", length=250)
    private String paymentConditions;
    @JoinColumn(name="primary_responsible_user_id")
    @ManyToOne(optional=true)
    private User primaryResponsibleUser;
    @JoinColumn(name="accounted_by_user_id")
    @ManyToOne(optional=true)
    private User accountedByUser;
    @JoinColumn(name="assigned_squad_id")
    @ManyToOne
    private User assignedSquad;
    @Convert(converter=NullStringConverter.class)
    @Column(name="cost_center", length=15)
    private String costCenter;
    @Enumerated(value=EnumType.STRING)
    @Column(name="invoice_type", length=50)
    private EInvoiceType invoiceType;
    @Convert(converter=NullStringConverter.class)
    @Column(name="invoice_type_comment", length=250)
    private String invoiceTypeComment;
    @Column(name="invoice_date")
    private LocalDate invoiceDate;
    @Column(name="posting_date")
    private LocalDate postingDate;
    @Convert(converter=NullStringConverter.class)
    @Column(name="contact_person", length=100)
    private String contactPerson;
    @Column(name="order_date")
    private LocalDate orderDate;
    @Convert(converter=NullStringConverter.class)
    @Column(name="order_description", length=250)
    private String orderDescription;
    @Convert(converter=NullStringConverter.class)
    @Column(name="order_number", length=30)
    private String orderNumber;
    @Convert(converter=NullStringConverter.class)
    @Column(name="voucher_number", length=50)
    private String voucherNumber;
    @Convert(converter=NullStringConverter.class)
    @Column(name="credit_voucher_number", length=50)
    private String creditVoucherNumber;
    @Convert(converter=NullStringConverter.class)
    @Column(name="construction_site", length=250)
    private String constructionSite;
    @Column(name="project_execution_start_date")
    private LocalDate projectExecutionStartDate;
    @Column(name="project_execution_end_date")
    private LocalDate projectExecutionEndDate;
    @JoinColumn(name="invoice_address_id")
    @ManyToOne(optional=true)
    private Address invoiceAddress;
    @Convert(converter=NullStringConverter.class)
    @Column(name="invoice_name", length=250)
    private String invoiceName;
    @Convert(converter=NullStringConverter.class)
    @Column(name="invoice_address_suffix", length=250)
    private String invoiceAddressSuffix;
    @Convert(converter=NullStringConverter.class)
    @Column(name="invoice_po_box", length=250)
    private String invoicePoBox;
    @Convert(converter=NullStringConverter.class)
    @Column(name="invoice_street", length=50)
    private String invoiceStreet;
    @Convert(converter=NullStringConverter.class)
    @Column(name="invoice_street_no", length=10)
    private String invoiceStreetNo;
    @Convert(converter=NullStringConverter.class)
    @Column(name="invoice_zip", length=50)
    private String invoiceZip;
    @Convert(converter=NullStringConverter.class)
    @Column(name="invoice_city", length=50)
    private String invoiceCity;
    @Convert(converter=NullStringConverter.class)
    @Column(name="invoice_country", length=50)
    private String invoiceCountry;
    @Convert(converter=NullStringConverter.class)
    @Column(name="invoice_email", length=250)
    private String invoiceEmail;
    @Convert(converter=NullStringConverter.class)
    @Column(name="invoice_portal", length=1000)
    private String invoicePortal;
    @Convert(converter=NullStringConverter.class)
    @Column(name="invoice_remarks", length=250)
    private String invoiceRemarks;
    @JoinColumn(name="invoice_ref_address_id")
    @ManyToOne(optional=true)
    private Address invoiceRefAddress;
    @Convert(converter=NullStringConverter.class)
    @Column(name="invoice_ref_name", length=250)
    private String invoiceRefName;
    @Convert(converter=NullStringConverter.class)
    @Column(name="invoice_ref_address_suffix", length=250)
    private String invoiceRefAddressSuffix;
    @Convert(converter=NullStringConverter.class)
    @Column(name="invoice_ref_po_box", length=250)
    private String invoiceRefPoBox;
    @Convert(converter=NullStringConverter.class)
    @Column(name="invoice_ref_street", length=50)
    private String invoiceRefStreet;
    @Convert(converter=NullStringConverter.class)
    @Column(name="invoice_ref_street_no", length=10)
    private String invoiceRefStreetNo;
    @Convert(converter=NullStringConverter.class)
    @Column(name="invoice_ref_zip", length=50)
    private String invoiceRefZip;
    @Convert(converter=NullStringConverter.class)
    @Column(name="invoice_ref_city", length=50)
    private String invoiceRefCity;
    @Convert(converter=NullStringConverter.class)
    @Column(name="invoice_ref_country", length=50)
    private String invoiceRefCountry;
    @Convert(converter=NullStringConverter.class)
    @Column(name="invoice_ref_email", length=250)
    private String invoiceRefEmail;
    @Convert(converter=NullStringConverter.class)
    @Column(name="invoice_ref_portal", length=1000)
    private String invoiceRefPortal;
    @Convert(converter=NullStringConverter.class)
    @Column(name="invoice_ref_remarks", length=250)
    private String invoiceRefRemarks;
    @Convert(converter=NullStringConverter.class)
    @Column(name="additional_info_header_1", length=50)
    private String additionalInfoHeader1;
    @Convert(converter=NullStringConverter.class)
    @Column(name="additional_info_detail_1", length=1000)
    private String additionalInfoDetail1;
    @Convert(converter=NullStringConverter.class)
    @Column(name="additional_info_header_2", length=50)
    private String additionalInfoHeader2;
    @Convert(converter=NullStringConverter.class)
    @Column(name="additional_info_detail_2", length=1000)
    private String additionalInfoDetail2;
    @Convert(converter=NullStringConverter.class)
    @Column(name="additional_info_header_3", length=50)
    private String additionalInfoHeader3;
    @Convert(converter=NullStringConverter.class)
    @Column(name="additional_info_detail_3", length=1000)
    private String additionalInfoDetail3;
    @Convert(converter=NullStringConverter.class)
    @Column(name="attachments", length=250)
    private String attachments;
    @Convert(converter=NullStringConverter.class)
    @Column(name="additional_attachments", length=250)
    private String additionalAttachments;
    @Convert(converter=NullStringConverter.class)
    @Column(name="footer_text", length=1000)
    private String footerText;
    @Column(name="finance_company_number", length=10)
    private String financeCompanyNumber;
    @Column(name="finance_accounting_text", length=30)
    private String financeAccountingText;
    @Column(name="finance_time_for_payment")
    private Integer financeTimeForPayment;
    @Column(name="finance_cash_discount_time_1")
    private Integer financeCashDiscountTime1;
    @Column(name="finance_cash_discount_1")
    private BigDecimal financeCashDiscount1;
    @Column(name="finance_cash_discount_time_2")
    private Integer financeCashDiscountTime2;
    @Column(name="finance_cash_discount_2")
    private BigDecimal financeCashDiscount2;
    @Column(name="finance_debtor_account_number", length=12)
    private String financeDebtorAccountNumber;
    @Column(name="finance_tax_key")
    private String financeTaxKeyValue;
    @Column(name="finance_account", length=12)
    private String financeAccount;
    @Column(name="finance_routing_reference_id", length=100)
    private String financeRoutingReferenceId;
    @Column(name="subtotal_wo_discount_value_net")
    private BigDecimal subtotalWithoutDiscountValueNet;
    @Column(name="subtotal_w_discount_value_net")
    private BigDecimal subtotalWithDiscountValueNet;
    @Column(name="total_discount_value_net")
    private BigDecimal totalDiscountValueNet;
    @Column(name="total_value_net")
    private BigDecimal totalValueNet;
    @Column(name="total_value_gross")
    private BigDecimal totalValueGross;
    @Column(name="vat_percent")
    private BigDecimal vatPercent;
    @Column(name="vat_value")
    private BigDecimal vatValue;
    @Column(name="invoice_due_value_gross")
    private BigDecimal invoiceDueValueGross;
    @Column(name="flag_security_retention")
    private Boolean flagSecurityRetention;
    @Column(name="warranty_sec_ret_percent")
    private BigDecimal warrantySecurityRetentionPercent;
    @Column(name="warranty_sec_ret_value")
    private BigDecimal warrantySecurityRetentionValue;
    @Column(name="fulfillment_sec_ret_percent")
    private BigDecimal fulfillmentSecurityRetentionPercent;
    @Column(name="fulfillment_sec_ret_value")
    private BigDecimal fulfillmentSecurityRetentionValue;
    @Column(name="fulfillment_sec_ret_cumu_value")
    private BigDecimal fulfillmentSecurityRetentionCumulativeValue;
    @Column(name="internal_wage_overall")
    private BigDecimal internalWageOverall;
    @Column(name="squad_wage_overall")
    private BigDecimal squadWageOverall;
    @Column(name="company_wage_overall")
    private BigDecimal companyWageOverall;
    @Column(name="mat_purchase_price_overall")
    private BigDecimal materialPurchasePriceOverall;
    @Column(name="mat_selling_price_overall")
    private BigDecimal materialSellingPriceOverall;
    @Column(name="es_purchase_price_overall")
    private BigDecimal externalServicePurchasePriceOverall;
    @Column(name="es_selling_price_overall")
    private BigDecimal externalServiceSellingPriceOverall;
    @Column(name="general_discount")
    private BigDecimal generalDiscount;
    @Column(name="other_discount")
    private BigDecimal otherDiscount;
    @Column(name="expect_pdf_value_overall_net")
    private BigDecimal expectedPDFValueOverallNet;
    @Column(name="expect_pdf_vat")
    private BigDecimal expectedPDFVAT;
    @Column(name="expect_pdf_value_overall_vat")
    private BigDecimal expectedPDFValueOverallVAT;
    @Column(name="expect_pdf_value_overall_gross")
    private BigDecimal expectedPDFValueOverallGross;
    @Column(name="expect_pdf_cost_center")
    private String expectedPDFCostCenter;
    @JoinColumn(name="finance_tax_key_id")
    @ManyToOne(fetch=FetchType.EAGER)
    private TaxKey financeTaxKey;
    @Column(name="cancellation_remarks")
    private String cancellationRemarks;
    @Column(name="cancellation_debit_note")
    private String cancellationDebitNote;
    @Column(name="cancellation_date")
    private LocalDate cancellationDate;
    @Column(name="cancellation_period")
    private LocalDate cancellationPeriod;
    @Convert(converter=NullStringConverter.class)
    @Column(name="import_errors", length=2000)
    private String importErrors;
    @Convert(converter=NullStringConverter.class)
    @Column(name="import_file_name", length=250)
    private String importFileName;
    @Convert(converter=NullStringConverter.class)
    @Column(name="calculated_measurement_numbers", length=1000)
    private String measurementNumbers;
    @JoinColumn(name="er2_export_user_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private User er2ExportedBy;
    @Column(name="er2_exported_on")
    private LocalDateTime er2ExportedOn;
    @JoinColumn(name="printed_by_user_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private User printedByUser;
    @Column(name="printed_on")
    private LocalDateTime printedOn;
    @Enumerated(value=EnumType.STRING)
    @Column(name="dms_export_state")
    private EInvoiceExportState dmsExportState;
    @JoinColumn(name="dms_export_user_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private User dmsExportedBy;
    @Column(name="dms_exported_on")
    private LocalDateTime dmsExportedOn;
    @Column(name="dms_exported_to_path")
    private String dmsExportedToPath;
    @Column(name="dms_exported_value")
    private BigDecimal dmsExportedValue;
    @Enumerated(value=EnumType.STRING)
    @Column(name="dms_comp_grp_export_state")
    private EInvoiceExportState dmsCompanyGroupExportState;
    @Column(name="dms_comp_grp_exported_on")
    private LocalDateTime dmsCompanyGroupExportedOn;
    @Column(name="dms_comp_grp_exported_to_path")
    private String dmsCompanyGroupExportedToPath;
    @Enumerated(value=EnumType.STRING)
    @Column(name="file_store_export_state")
    private EInvoiceExportState fileStoreExportState;
    @Column(name="file_store_exported_on")
    private LocalDateTime fileStoreExportedOn;
    @Column(name="file_store_exported_to_path")
    private String fileStoreExportedToPath;
    @Column(name="flag_closed")
    private Boolean flagClosed;
    @Column(name="closed_on")
    private LocalDateTime closedOn;
    @JoinColumn(name="closed_by_invoice_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private Invoice closedByInvoice;
    @JoinColumn(name="closed_by_user_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private User closedByUser;
    @JoinColumn(name="referenced_by_invoice_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private Invoice referencedByInvoice;
    @Column(name="option_print_13b")
    private Boolean optionPrint13bParagraph;
    @Column(name="option_print_subcontractor")
    private Boolean optionPrintSubcontractorParagraph;
    @Column(name="option_print_stromnetz")
    private Boolean optionPrintStromnetzParagraph;
    @Column(name="option_print_cumulative")
    private Boolean optionCumulativePrint;
    @Column(name="option_print_measurements")
    private Boolean optionMeasurementPrint;
    @Column(name="option_print_measurements_cumu")
    private Boolean optionMeasurementCumulativePrint;
    @Column(name="option_print_m_cumu_consid_rem")
    private Boolean optionMeasurementCumulativePrintConsiderRemarks;
    @Column(name="option_print_ignore_addendum")
    private Boolean optionIgnoreAddendum;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="invoice", cascade={CascadeType.ALL})
    private Set<InvoiceMeasurement> invoiceMeasurements;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="invoice", cascade={CascadeType.ALL})
    private Set<InvoicePosition> invoicePositions;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="closedByInvoice", cascade={CascadeType.ALL})
    private Set<Invoice> closedInvoices;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="invoice", cascade={CascadeType.ALL})
    private Set<InvoiceAttachment> invoiceAttachments;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="invoice", cascade={CascadeType.ALL})
    private Set<InvoiceAddendumDiscount> invoiceAddendumDiscounts;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="invoice", cascade={CascadeType.ALL})
    private Set<InvoiceSupplement> invoiceSupplements;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass((Object)this) != Hibernate.getClass((Object)o)) {
            return false;
        }
        Invoice invoice = (Invoice)o;
        return this.id != null && Objects.equals(this.id, invoice.getId());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public Long getId() {
        return this.id;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public EInvoiceSource getInvoiceSource() {
        return this.invoiceSource;
    }

    public ESearchIndexState getSearchIndexState() {
        return this.searchIndexState;
    }

    public LocalDateTime getInvoiceStateSince() {
        return this.invoiceStateSince;
    }

    public EInvoiceState getInvoiceState() {
        return this.invoiceState;
    }

    public Quotation getQuotation() {
        return this.quotation;
    }

    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public Integer getSequentialNumber() {
        return this.sequentialNumber;
    }

    public Integer getInternalPartialNumber() {
        return this.internalPartialNumber;
    }

    public Integer getInternalPartialFinalNumber() {
        return this.internalPartialFinalNumber;
    }

    @Deprecated
    public Integer getCumulativeNumber() {
        return this.cumulativeNumber;
    }

    public String getPaymentConditions() {
        return this.paymentConditions;
    }

    public User getPrimaryResponsibleUser() {
        return this.primaryResponsibleUser;
    }

    public User getAccountedByUser() {
        return this.accountedByUser;
    }

    public User getAssignedSquad() {
        return this.assignedSquad;
    }

    public String getCostCenter() {
        return this.costCenter;
    }

    public EInvoiceType getInvoiceType() {
        return this.invoiceType;
    }

    public String getInvoiceTypeComment() {
        return this.invoiceTypeComment;
    }

    public LocalDate getInvoiceDate() {
        return this.invoiceDate;
    }

    public LocalDate getPostingDate() {
        return this.postingDate;
    }

    public String getContactPerson() {
        return this.contactPerson;
    }

    public LocalDate getOrderDate() {
        return this.orderDate;
    }

    public String getOrderDescription() {
        return this.orderDescription;
    }

    public String getOrderNumber() {
        return this.orderNumber;
    }

    public String getVoucherNumber() {
        return this.voucherNumber;
    }

    public String getCreditVoucherNumber() {
        return this.creditVoucherNumber;
    }

    public String getConstructionSite() {
        return this.constructionSite;
    }

    public LocalDate getProjectExecutionStartDate() {
        return this.projectExecutionStartDate;
    }

    public LocalDate getProjectExecutionEndDate() {
        return this.projectExecutionEndDate;
    }

    public Address getInvoiceAddress() {
        return this.invoiceAddress;
    }

    public String getInvoiceName() {
        return this.invoiceName;
    }

    public String getInvoiceAddressSuffix() {
        return this.invoiceAddressSuffix;
    }

    public String getInvoicePoBox() {
        return this.invoicePoBox;
    }

    public String getInvoiceStreet() {
        return this.invoiceStreet;
    }

    public String getInvoiceStreetNo() {
        return this.invoiceStreetNo;
    }

    public String getInvoiceZip() {
        return this.invoiceZip;
    }

    public String getInvoiceCity() {
        return this.invoiceCity;
    }

    public String getInvoiceCountry() {
        return this.invoiceCountry;
    }

    public String getInvoiceEmail() {
        return this.invoiceEmail;
    }

    public String getInvoicePortal() {
        return this.invoicePortal;
    }

    public String getInvoiceRemarks() {
        return this.invoiceRemarks;
    }

    public Address getInvoiceRefAddress() {
        return this.invoiceRefAddress;
    }

    public String getInvoiceRefName() {
        return this.invoiceRefName;
    }

    public String getInvoiceRefAddressSuffix() {
        return this.invoiceRefAddressSuffix;
    }

    public String getInvoiceRefPoBox() {
        return this.invoiceRefPoBox;
    }

    public String getInvoiceRefStreet() {
        return this.invoiceRefStreet;
    }

    public String getInvoiceRefStreetNo() {
        return this.invoiceRefStreetNo;
    }

    public String getInvoiceRefZip() {
        return this.invoiceRefZip;
    }

    public String getInvoiceRefCity() {
        return this.invoiceRefCity;
    }

    public String getInvoiceRefCountry() {
        return this.invoiceRefCountry;
    }

    public String getInvoiceRefEmail() {
        return this.invoiceRefEmail;
    }

    public String getInvoiceRefPortal() {
        return this.invoiceRefPortal;
    }

    public String getInvoiceRefRemarks() {
        return this.invoiceRefRemarks;
    }

    public String getAdditionalInfoHeader1() {
        return this.additionalInfoHeader1;
    }

    public String getAdditionalInfoDetail1() {
        return this.additionalInfoDetail1;
    }

    public String getAdditionalInfoHeader2() {
        return this.additionalInfoHeader2;
    }

    public String getAdditionalInfoDetail2() {
        return this.additionalInfoDetail2;
    }

    public String getAdditionalInfoHeader3() {
        return this.additionalInfoHeader3;
    }

    public String getAdditionalInfoDetail3() {
        return this.additionalInfoDetail3;
    }

    public String getAttachments() {
        return this.attachments;
    }

    public String getAdditionalAttachments() {
        return this.additionalAttachments;
    }

    public String getFooterText() {
        return this.footerText;
    }

    public String getFinanceCompanyNumber() {
        return this.financeCompanyNumber;
    }

    public String getFinanceAccountingText() {
        return this.financeAccountingText;
    }

    public Integer getFinanceTimeForPayment() {
        return this.financeTimeForPayment;
    }

    public Integer getFinanceCashDiscountTime1() {
        return this.financeCashDiscountTime1;
    }

    public BigDecimal getFinanceCashDiscount1() {
        return this.financeCashDiscount1;
    }

    public Integer getFinanceCashDiscountTime2() {
        return this.financeCashDiscountTime2;
    }

    public BigDecimal getFinanceCashDiscount2() {
        return this.financeCashDiscount2;
    }

    public String getFinanceDebtorAccountNumber() {
        return this.financeDebtorAccountNumber;
    }

    public String getFinanceTaxKeyValue() {
        return this.financeTaxKeyValue;
    }

    public String getFinanceAccount() {
        return this.financeAccount;
    }

    public String getFinanceRoutingReferenceId() {
        return this.financeRoutingReferenceId;
    }

    public BigDecimal getSubtotalWithoutDiscountValueNet() {
        return this.subtotalWithoutDiscountValueNet;
    }

    public BigDecimal getSubtotalWithDiscountValueNet() {
        return this.subtotalWithDiscountValueNet;
    }

    public BigDecimal getTotalDiscountValueNet() {
        return this.totalDiscountValueNet;
    }

    public BigDecimal getTotalValueNet() {
        return this.totalValueNet;
    }

    public BigDecimal getTotalValueGross() {
        return this.totalValueGross;
    }

    public BigDecimal getVatPercent() {
        return this.vatPercent;
    }

    public BigDecimal getVatValue() {
        return this.vatValue;
    }

    public BigDecimal getInvoiceDueValueGross() {
        return this.invoiceDueValueGross;
    }

    public Boolean getFlagSecurityRetention() {
        return this.flagSecurityRetention;
    }

    public BigDecimal getWarrantySecurityRetentionPercent() {
        return this.warrantySecurityRetentionPercent;
    }

    public BigDecimal getWarrantySecurityRetentionValue() {
        return this.warrantySecurityRetentionValue;
    }

    public BigDecimal getFulfillmentSecurityRetentionPercent() {
        return this.fulfillmentSecurityRetentionPercent;
    }

    public BigDecimal getFulfillmentSecurityRetentionValue() {
        return this.fulfillmentSecurityRetentionValue;
    }

    public BigDecimal getFulfillmentSecurityRetentionCumulativeValue() {
        return this.fulfillmentSecurityRetentionCumulativeValue;
    }

    public BigDecimal getInternalWageOverall() {
        return this.internalWageOverall;
    }

    public BigDecimal getSquadWageOverall() {
        return this.squadWageOverall;
    }

    public BigDecimal getCompanyWageOverall() {
        return this.companyWageOverall;
    }

    public BigDecimal getMaterialPurchasePriceOverall() {
        return this.materialPurchasePriceOverall;
    }

    public BigDecimal getMaterialSellingPriceOverall() {
        return this.materialSellingPriceOverall;
    }

    public BigDecimal getExternalServicePurchasePriceOverall() {
        return this.externalServicePurchasePriceOverall;
    }

    public BigDecimal getExternalServiceSellingPriceOverall() {
        return this.externalServiceSellingPriceOverall;
    }

    public BigDecimal getGeneralDiscount() {
        return this.generalDiscount;
    }

    public BigDecimal getOtherDiscount() {
        return this.otherDiscount;
    }

    public BigDecimal getExpectedPDFValueOverallNet() {
        return this.expectedPDFValueOverallNet;
    }

    public BigDecimal getExpectedPDFVAT() {
        return this.expectedPDFVAT;
    }

    public BigDecimal getExpectedPDFValueOverallVAT() {
        return this.expectedPDFValueOverallVAT;
    }

    public BigDecimal getExpectedPDFValueOverallGross() {
        return this.expectedPDFValueOverallGross;
    }

    public String getExpectedPDFCostCenter() {
        return this.expectedPDFCostCenter;
    }

    public TaxKey getFinanceTaxKey() {
        return this.financeTaxKey;
    }

    public String getCancellationRemarks() {
        return this.cancellationRemarks;
    }

    public String getCancellationDebitNote() {
        return this.cancellationDebitNote;
    }

    public LocalDate getCancellationDate() {
        return this.cancellationDate;
    }

    public LocalDate getCancellationPeriod() {
        return this.cancellationPeriod;
    }

    public String getImportErrors() {
        return this.importErrors;
    }

    public String getImportFileName() {
        return this.importFileName;
    }

    public String getMeasurementNumbers() {
        return this.measurementNumbers;
    }

    public User getEr2ExportedBy() {
        return this.er2ExportedBy;
    }

    public LocalDateTime getEr2ExportedOn() {
        return this.er2ExportedOn;
    }

    public User getPrintedByUser() {
        return this.printedByUser;
    }

    public LocalDateTime getPrintedOn() {
        return this.printedOn;
    }

    public EInvoiceExportState getDmsExportState() {
        return this.dmsExportState;
    }

    public User getDmsExportedBy() {
        return this.dmsExportedBy;
    }

    public LocalDateTime getDmsExportedOn() {
        return this.dmsExportedOn;
    }

    public String getDmsExportedToPath() {
        return this.dmsExportedToPath;
    }

    public BigDecimal getDmsExportedValue() {
        return this.dmsExportedValue;
    }

    public EInvoiceExportState getDmsCompanyGroupExportState() {
        return this.dmsCompanyGroupExportState;
    }

    public LocalDateTime getDmsCompanyGroupExportedOn() {
        return this.dmsCompanyGroupExportedOn;
    }

    public String getDmsCompanyGroupExportedToPath() {
        return this.dmsCompanyGroupExportedToPath;
    }

    public EInvoiceExportState getFileStoreExportState() {
        return this.fileStoreExportState;
    }

    public LocalDateTime getFileStoreExportedOn() {
        return this.fileStoreExportedOn;
    }

    public String getFileStoreExportedToPath() {
        return this.fileStoreExportedToPath;
    }

    public Boolean getFlagClosed() {
        return this.flagClosed;
    }

    public LocalDateTime getClosedOn() {
        return this.closedOn;
    }

    public Invoice getClosedByInvoice() {
        return this.closedByInvoice;
    }

    public User getClosedByUser() {
        return this.closedByUser;
    }

    public Invoice getReferencedByInvoice() {
        return this.referencedByInvoice;
    }

    public Boolean getOptionPrint13bParagraph() {
        return this.optionPrint13bParagraph;
    }

    public Boolean getOptionPrintSubcontractorParagraph() {
        return this.optionPrintSubcontractorParagraph;
    }

    public Boolean getOptionPrintStromnetzParagraph() {
        return this.optionPrintStromnetzParagraph;
    }

    public Boolean getOptionCumulativePrint() {
        return this.optionCumulativePrint;
    }

    public Boolean getOptionMeasurementPrint() {
        return this.optionMeasurementPrint;
    }

    public Boolean getOptionMeasurementCumulativePrint() {
        return this.optionMeasurementCumulativePrint;
    }

    public Boolean getOptionMeasurementCumulativePrintConsiderRemarks() {
        return this.optionMeasurementCumulativePrintConsiderRemarks;
    }

    public Boolean getOptionIgnoreAddendum() {
        return this.optionIgnoreAddendum;
    }

    public Set<InvoiceMeasurement> getInvoiceMeasurements() {
        return this.invoiceMeasurements;
    }

    public Set<InvoicePosition> getInvoicePositions() {
        return this.invoicePositions;
    }

    public Set<Invoice> getClosedInvoices() {
        return this.closedInvoices;
    }

    public Set<InvoiceAttachment> getInvoiceAttachments() {
        return this.invoiceAttachments;
    }

    public Set<InvoiceAddendumDiscount> getInvoiceAddendumDiscounts() {
        return this.invoiceAddendumDiscounts;
    }

    public Set<InvoiceSupplement> getInvoiceSupplements() {
        return this.invoiceSupplements;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public void setInvoiceSource(EInvoiceSource invoiceSource) {
        this.invoiceSource = invoiceSource;
    }

    public void setSearchIndexState(ESearchIndexState searchIndexState) {
        this.searchIndexState = searchIndexState;
    }

    public void setInvoiceStateSince(LocalDateTime invoiceStateSince) {
        this.invoiceStateSince = invoiceStateSince;
    }

    public void setInvoiceState(EInvoiceState invoiceState) {
        this.invoiceState = invoiceState;
    }

    public void setQuotation(Quotation quotation) {
        this.quotation = quotation;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    public void setSequentialNumber(Integer sequentialNumber) {
        this.sequentialNumber = sequentialNumber;
    }

    public void setInternalPartialNumber(Integer internalPartialNumber) {
        this.internalPartialNumber = internalPartialNumber;
    }

    public void setInternalPartialFinalNumber(Integer internalPartialFinalNumber) {
        this.internalPartialFinalNumber = internalPartialFinalNumber;
    }

    @Deprecated
    public void setCumulativeNumber(Integer cumulativeNumber) {
        this.cumulativeNumber = cumulativeNumber;
    }

    public void setPaymentConditions(String paymentConditions) {
        this.paymentConditions = paymentConditions;
    }

    public void setPrimaryResponsibleUser(User primaryResponsibleUser) {
        this.primaryResponsibleUser = primaryResponsibleUser;
    }

    public void setAccountedByUser(User accountedByUser) {
        this.accountedByUser = accountedByUser;
    }

    public void setAssignedSquad(User assignedSquad) {
        this.assignedSquad = assignedSquad;
    }

    public void setCostCenter(String costCenter) {
        this.costCenter = costCenter;
    }

    public void setInvoiceType(EInvoiceType invoiceType) {
        this.invoiceType = invoiceType;
    }

    public void setInvoiceTypeComment(String invoiceTypeComment) {
        this.invoiceTypeComment = invoiceTypeComment;
    }

    public void setInvoiceDate(LocalDate invoiceDate) {
        this.invoiceDate = invoiceDate;
    }

    public void setPostingDate(LocalDate postingDate) {
        this.postingDate = postingDate;
    }

    public void setContactPerson(String contactPerson) {
        this.contactPerson = contactPerson;
    }

    public void setOrderDate(LocalDate orderDate) {
        this.orderDate = orderDate;
    }

    public void setOrderDescription(String orderDescription) {
        this.orderDescription = orderDescription;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public void setVoucherNumber(String voucherNumber) {
        this.voucherNumber = voucherNumber;
    }

    public void setCreditVoucherNumber(String creditVoucherNumber) {
        this.creditVoucherNumber = creditVoucherNumber;
    }

    public void setConstructionSite(String constructionSite) {
        this.constructionSite = constructionSite;
    }

    public void setProjectExecutionStartDate(LocalDate projectExecutionStartDate) {
        this.projectExecutionStartDate = projectExecutionStartDate;
    }

    public void setProjectExecutionEndDate(LocalDate projectExecutionEndDate) {
        this.projectExecutionEndDate = projectExecutionEndDate;
    }

    public void setInvoiceAddress(Address invoiceAddress) {
        this.invoiceAddress = invoiceAddress;
    }

    public void setInvoiceName(String invoiceName) {
        this.invoiceName = invoiceName;
    }

    public void setInvoiceAddressSuffix(String invoiceAddressSuffix) {
        this.invoiceAddressSuffix = invoiceAddressSuffix;
    }

    public void setInvoicePoBox(String invoicePoBox) {
        this.invoicePoBox = invoicePoBox;
    }

    public void setInvoiceStreet(String invoiceStreet) {
        this.invoiceStreet = invoiceStreet;
    }

    public void setInvoiceStreetNo(String invoiceStreetNo) {
        this.invoiceStreetNo = invoiceStreetNo;
    }

    public void setInvoiceZip(String invoiceZip) {
        this.invoiceZip = invoiceZip;
    }

    public void setInvoiceCity(String invoiceCity) {
        this.invoiceCity = invoiceCity;
    }

    public void setInvoiceCountry(String invoiceCountry) {
        this.invoiceCountry = invoiceCountry;
    }

    public void setInvoiceEmail(String invoiceEmail) {
        this.invoiceEmail = invoiceEmail;
    }

    public void setInvoicePortal(String invoicePortal) {
        this.invoicePortal = invoicePortal;
    }

    public void setInvoiceRemarks(String invoiceRemarks) {
        this.invoiceRemarks = invoiceRemarks;
    }

    public void setInvoiceRefAddress(Address invoiceRefAddress) {
        this.invoiceRefAddress = invoiceRefAddress;
    }

    public void setInvoiceRefName(String invoiceRefName) {
        this.invoiceRefName = invoiceRefName;
    }

    public void setInvoiceRefAddressSuffix(String invoiceRefAddressSuffix) {
        this.invoiceRefAddressSuffix = invoiceRefAddressSuffix;
    }

    public void setInvoiceRefPoBox(String invoiceRefPoBox) {
        this.invoiceRefPoBox = invoiceRefPoBox;
    }

    public void setInvoiceRefStreet(String invoiceRefStreet) {
        this.invoiceRefStreet = invoiceRefStreet;
    }

    public void setInvoiceRefStreetNo(String invoiceRefStreetNo) {
        this.invoiceRefStreetNo = invoiceRefStreetNo;
    }

    public void setInvoiceRefZip(String invoiceRefZip) {
        this.invoiceRefZip = invoiceRefZip;
    }

    public void setInvoiceRefCity(String invoiceRefCity) {
        this.invoiceRefCity = invoiceRefCity;
    }

    public void setInvoiceRefCountry(String invoiceRefCountry) {
        this.invoiceRefCountry = invoiceRefCountry;
    }

    public void setInvoiceRefEmail(String invoiceRefEmail) {
        this.invoiceRefEmail = invoiceRefEmail;
    }

    public void setInvoiceRefPortal(String invoiceRefPortal) {
        this.invoiceRefPortal = invoiceRefPortal;
    }

    public void setInvoiceRefRemarks(String invoiceRefRemarks) {
        this.invoiceRefRemarks = invoiceRefRemarks;
    }

    public void setAdditionalInfoHeader1(String additionalInfoHeader1) {
        this.additionalInfoHeader1 = additionalInfoHeader1;
    }

    public void setAdditionalInfoDetail1(String additionalInfoDetail1) {
        this.additionalInfoDetail1 = additionalInfoDetail1;
    }

    public void setAdditionalInfoHeader2(String additionalInfoHeader2) {
        this.additionalInfoHeader2 = additionalInfoHeader2;
    }

    public void setAdditionalInfoDetail2(String additionalInfoDetail2) {
        this.additionalInfoDetail2 = additionalInfoDetail2;
    }

    public void setAdditionalInfoHeader3(String additionalInfoHeader3) {
        this.additionalInfoHeader3 = additionalInfoHeader3;
    }

    public void setAdditionalInfoDetail3(String additionalInfoDetail3) {
        this.additionalInfoDetail3 = additionalInfoDetail3;
    }

    public void setAttachments(String attachments) {
        this.attachments = attachments;
    }

    public void setAdditionalAttachments(String additionalAttachments) {
        this.additionalAttachments = additionalAttachments;
    }

    public void setFooterText(String footerText) {
        this.footerText = footerText;
    }

    public void setFinanceCompanyNumber(String financeCompanyNumber) {
        this.financeCompanyNumber = financeCompanyNumber;
    }

    public void setFinanceAccountingText(String financeAccountingText) {
        this.financeAccountingText = financeAccountingText;
    }

    public void setFinanceTimeForPayment(Integer financeTimeForPayment) {
        this.financeTimeForPayment = financeTimeForPayment;
    }

    public void setFinanceCashDiscountTime1(Integer financeCashDiscountTime1) {
        this.financeCashDiscountTime1 = financeCashDiscountTime1;
    }

    public void setFinanceCashDiscount1(BigDecimal financeCashDiscount1) {
        this.financeCashDiscount1 = financeCashDiscount1;
    }

    public void setFinanceCashDiscountTime2(Integer financeCashDiscountTime2) {
        this.financeCashDiscountTime2 = financeCashDiscountTime2;
    }

    public void setFinanceCashDiscount2(BigDecimal financeCashDiscount2) {
        this.financeCashDiscount2 = financeCashDiscount2;
    }

    public void setFinanceDebtorAccountNumber(String financeDebtorAccountNumber) {
        this.financeDebtorAccountNumber = financeDebtorAccountNumber;
    }

    public void setFinanceTaxKeyValue(String financeTaxKeyValue) {
        this.financeTaxKeyValue = financeTaxKeyValue;
    }

    public void setFinanceAccount(String financeAccount) {
        this.financeAccount = financeAccount;
    }

    public void setFinanceRoutingReferenceId(String financeRoutingReferenceId) {
        this.financeRoutingReferenceId = financeRoutingReferenceId;
    }

    public void setSubtotalWithoutDiscountValueNet(BigDecimal subtotalWithoutDiscountValueNet) {
        this.subtotalWithoutDiscountValueNet = subtotalWithoutDiscountValueNet;
    }

    public void setSubtotalWithDiscountValueNet(BigDecimal subtotalWithDiscountValueNet) {
        this.subtotalWithDiscountValueNet = subtotalWithDiscountValueNet;
    }

    public void setTotalDiscountValueNet(BigDecimal totalDiscountValueNet) {
        this.totalDiscountValueNet = totalDiscountValueNet;
    }

    public void setTotalValueNet(BigDecimal totalValueNet) {
        this.totalValueNet = totalValueNet;
    }

    public void setTotalValueGross(BigDecimal totalValueGross) {
        this.totalValueGross = totalValueGross;
    }

    public void setVatPercent(BigDecimal vatPercent) {
        this.vatPercent = vatPercent;
    }

    public void setVatValue(BigDecimal vatValue) {
        this.vatValue = vatValue;
    }

    public void setInvoiceDueValueGross(BigDecimal invoiceDueValueGross) {
        this.invoiceDueValueGross = invoiceDueValueGross;
    }

    public void setFlagSecurityRetention(Boolean flagSecurityRetention) {
        this.flagSecurityRetention = flagSecurityRetention;
    }

    public void setWarrantySecurityRetentionPercent(BigDecimal warrantySecurityRetentionPercent) {
        this.warrantySecurityRetentionPercent = warrantySecurityRetentionPercent;
    }

    public void setWarrantySecurityRetentionValue(BigDecimal warrantySecurityRetentionValue) {
        this.warrantySecurityRetentionValue = warrantySecurityRetentionValue;
    }

    public void setFulfillmentSecurityRetentionPercent(BigDecimal fulfillmentSecurityRetentionPercent) {
        this.fulfillmentSecurityRetentionPercent = fulfillmentSecurityRetentionPercent;
    }

    public void setFulfillmentSecurityRetentionValue(BigDecimal fulfillmentSecurityRetentionValue) {
        this.fulfillmentSecurityRetentionValue = fulfillmentSecurityRetentionValue;
    }

    public void setFulfillmentSecurityRetentionCumulativeValue(BigDecimal fulfillmentSecurityRetentionCumulativeValue) {
        this.fulfillmentSecurityRetentionCumulativeValue = fulfillmentSecurityRetentionCumulativeValue;
    }

    public void setInternalWageOverall(BigDecimal internalWageOverall) {
        this.internalWageOverall = internalWageOverall;
    }

    public void setSquadWageOverall(BigDecimal squadWageOverall) {
        this.squadWageOverall = squadWageOverall;
    }

    public void setCompanyWageOverall(BigDecimal companyWageOverall) {
        this.companyWageOverall = companyWageOverall;
    }

    public void setMaterialPurchasePriceOverall(BigDecimal materialPurchasePriceOverall) {
        this.materialPurchasePriceOverall = materialPurchasePriceOverall;
    }

    public void setMaterialSellingPriceOverall(BigDecimal materialSellingPriceOverall) {
        this.materialSellingPriceOverall = materialSellingPriceOverall;
    }

    public void setExternalServicePurchasePriceOverall(BigDecimal externalServicePurchasePriceOverall) {
        this.externalServicePurchasePriceOverall = externalServicePurchasePriceOverall;
    }

    public void setExternalServiceSellingPriceOverall(BigDecimal externalServiceSellingPriceOverall) {
        this.externalServiceSellingPriceOverall = externalServiceSellingPriceOverall;
    }

    public void setGeneralDiscount(BigDecimal generalDiscount) {
        this.generalDiscount = generalDiscount;
    }

    public void setOtherDiscount(BigDecimal otherDiscount) {
        this.otherDiscount = otherDiscount;
    }

    public void setExpectedPDFValueOverallNet(BigDecimal expectedPDFValueOverallNet) {
        this.expectedPDFValueOverallNet = expectedPDFValueOverallNet;
    }

    public void setExpectedPDFVAT(BigDecimal expectedPDFVAT) {
        this.expectedPDFVAT = expectedPDFVAT;
    }

    public void setExpectedPDFValueOverallVAT(BigDecimal expectedPDFValueOverallVAT) {
        this.expectedPDFValueOverallVAT = expectedPDFValueOverallVAT;
    }

    public void setExpectedPDFValueOverallGross(BigDecimal expectedPDFValueOverallGross) {
        this.expectedPDFValueOverallGross = expectedPDFValueOverallGross;
    }

    public void setExpectedPDFCostCenter(String expectedPDFCostCenter) {
        this.expectedPDFCostCenter = expectedPDFCostCenter;
    }

    public void setFinanceTaxKey(TaxKey financeTaxKey) {
        this.financeTaxKey = financeTaxKey;
    }

    public void setCancellationRemarks(String cancellationRemarks) {
        this.cancellationRemarks = cancellationRemarks;
    }

    public void setCancellationDebitNote(String cancellationDebitNote) {
        this.cancellationDebitNote = cancellationDebitNote;
    }

    public void setCancellationDate(LocalDate cancellationDate) {
        this.cancellationDate = cancellationDate;
    }

    public void setCancellationPeriod(LocalDate cancellationPeriod) {
        this.cancellationPeriod = cancellationPeriod;
    }

    public void setImportErrors(String importErrors) {
        this.importErrors = importErrors;
    }

    public void setImportFileName(String importFileName) {
        this.importFileName = importFileName;
    }

    public void setMeasurementNumbers(String measurementNumbers) {
        this.measurementNumbers = measurementNumbers;
    }

    public void setEr2ExportedBy(User er2ExportedBy) {
        this.er2ExportedBy = er2ExportedBy;
    }

    public void setEr2ExportedOn(LocalDateTime er2ExportedOn) {
        this.er2ExportedOn = er2ExportedOn;
    }

    public void setPrintedByUser(User printedByUser) {
        this.printedByUser = printedByUser;
    }

    public void setPrintedOn(LocalDateTime printedOn) {
        this.printedOn = printedOn;
    }

    public void setDmsExportState(EInvoiceExportState dmsExportState) {
        this.dmsExportState = dmsExportState;
    }

    public void setDmsExportedBy(User dmsExportedBy) {
        this.dmsExportedBy = dmsExportedBy;
    }

    public void setDmsExportedOn(LocalDateTime dmsExportedOn) {
        this.dmsExportedOn = dmsExportedOn;
    }

    public void setDmsExportedToPath(String dmsExportedToPath) {
        this.dmsExportedToPath = dmsExportedToPath;
    }

    public void setDmsExportedValue(BigDecimal dmsExportedValue) {
        this.dmsExportedValue = dmsExportedValue;
    }

    public void setDmsCompanyGroupExportState(EInvoiceExportState dmsCompanyGroupExportState) {
        this.dmsCompanyGroupExportState = dmsCompanyGroupExportState;
    }

    public void setDmsCompanyGroupExportedOn(LocalDateTime dmsCompanyGroupExportedOn) {
        this.dmsCompanyGroupExportedOn = dmsCompanyGroupExportedOn;
    }

    public void setDmsCompanyGroupExportedToPath(String dmsCompanyGroupExportedToPath) {
        this.dmsCompanyGroupExportedToPath = dmsCompanyGroupExportedToPath;
    }

    public void setFileStoreExportState(EInvoiceExportState fileStoreExportState) {
        this.fileStoreExportState = fileStoreExportState;
    }

    public void setFileStoreExportedOn(LocalDateTime fileStoreExportedOn) {
        this.fileStoreExportedOn = fileStoreExportedOn;
    }

    public void setFileStoreExportedToPath(String fileStoreExportedToPath) {
        this.fileStoreExportedToPath = fileStoreExportedToPath;
    }

    public void setFlagClosed(Boolean flagClosed) {
        this.flagClosed = flagClosed;
    }

    public void setClosedOn(LocalDateTime closedOn) {
        this.closedOn = closedOn;
    }

    public void setClosedByInvoice(Invoice closedByInvoice) {
        this.closedByInvoice = closedByInvoice;
    }

    public void setClosedByUser(User closedByUser) {
        this.closedByUser = closedByUser;
    }

    public void setReferencedByInvoice(Invoice referencedByInvoice) {
        this.referencedByInvoice = referencedByInvoice;
    }

    public void setOptionPrint13bParagraph(Boolean optionPrint13bParagraph) {
        this.optionPrint13bParagraph = optionPrint13bParagraph;
    }

    public void setOptionPrintSubcontractorParagraph(Boolean optionPrintSubcontractorParagraph) {
        this.optionPrintSubcontractorParagraph = optionPrintSubcontractorParagraph;
    }

    public void setOptionPrintStromnetzParagraph(Boolean optionPrintStromnetzParagraph) {
        this.optionPrintStromnetzParagraph = optionPrintStromnetzParagraph;
    }

    public void setOptionCumulativePrint(Boolean optionCumulativePrint) {
        this.optionCumulativePrint = optionCumulativePrint;
    }

    public void setOptionMeasurementPrint(Boolean optionMeasurementPrint) {
        this.optionMeasurementPrint = optionMeasurementPrint;
    }

    public void setOptionMeasurementCumulativePrint(Boolean optionMeasurementCumulativePrint) {
        this.optionMeasurementCumulativePrint = optionMeasurementCumulativePrint;
    }

    public void setOptionMeasurementCumulativePrintConsiderRemarks(Boolean optionMeasurementCumulativePrintConsiderRemarks) {
        this.optionMeasurementCumulativePrintConsiderRemarks = optionMeasurementCumulativePrintConsiderRemarks;
    }

    public void setOptionIgnoreAddendum(Boolean optionIgnoreAddendum) {
        this.optionIgnoreAddendum = optionIgnoreAddendum;
    }

    public void setInvoiceMeasurements(Set<InvoiceMeasurement> invoiceMeasurements) {
        this.invoiceMeasurements = invoiceMeasurements;
    }

    public void setInvoicePositions(Set<InvoicePosition> invoicePositions) {
        this.invoicePositions = invoicePositions;
    }

    public void setClosedInvoices(Set<Invoice> closedInvoices) {
        this.closedInvoices = closedInvoices;
    }

    public void setInvoiceAttachments(Set<InvoiceAttachment> invoiceAttachments) {
        this.invoiceAttachments = invoiceAttachments;
    }

    public void setInvoiceAddendumDiscounts(Set<InvoiceAddendumDiscount> invoiceAddendumDiscounts) {
        this.invoiceAddendumDiscounts = invoiceAddendumDiscounts;
    }

    public void setInvoiceSupplements(Set<InvoiceSupplement> invoiceSupplements) {
        this.invoiceSupplements = invoiceSupplements;
    }

    public String toString() {
        return "Invoice(super=" + super.toString() + ", id=" + this.getId() + ", referenceId=" + this.getReferenceId() + ", invoiceSource=" + String.valueOf(this.getInvoiceSource()) + ", searchIndexState=" + String.valueOf(this.getSearchIndexState()) + ", invoiceStateSince=" + String.valueOf(this.getInvoiceStateSince()) + ", invoiceState=" + String.valueOf(this.getInvoiceState()) + ", invoiceNumber=" + this.getInvoiceNumber() + ", sequentialNumber=" + this.getSequentialNumber() + ", internalPartialNumber=" + this.getInternalPartialNumber() + ", internalPartialFinalNumber=" + this.getInternalPartialFinalNumber() + ", cumulativeNumber=" + this.getCumulativeNumber() + ", paymentConditions=" + this.getPaymentConditions() + ", costCenter=" + this.getCostCenter() + ", invoiceType=" + String.valueOf(this.getInvoiceType()) + ", invoiceTypeComment=" + this.getInvoiceTypeComment() + ", invoiceDate=" + String.valueOf(this.getInvoiceDate()) + ", postingDate=" + String.valueOf(this.getPostingDate()) + ", contactPerson=" + this.getContactPerson() + ", orderDate=" + String.valueOf(this.getOrderDate()) + ", orderDescription=" + this.getOrderDescription() + ", orderNumber=" + this.getOrderNumber() + ", voucherNumber=" + this.getVoucherNumber() + ", creditVoucherNumber=" + this.getCreditVoucherNumber() + ", constructionSite=" + this.getConstructionSite() + ", projectExecutionStartDate=" + String.valueOf(this.getProjectExecutionStartDate()) + ", projectExecutionEndDate=" + String.valueOf(this.getProjectExecutionEndDate()) + ", invoiceName=" + this.getInvoiceName() + ", invoiceAddressSuffix=" + this.getInvoiceAddressSuffix() + ", invoicePoBox=" + this.getInvoicePoBox() + ", invoiceStreet=" + this.getInvoiceStreet() + ", invoiceStreetNo=" + this.getInvoiceStreetNo() + ", invoiceZip=" + this.getInvoiceZip() + ", invoiceCity=" + this.getInvoiceCity() + ", invoiceCountry=" + this.getInvoiceCountry() + ", invoiceEmail=" + this.getInvoiceEmail() + ", invoicePortal=" + this.getInvoicePortal() + ", invoiceRemarks=" + this.getInvoiceRemarks() + ", invoiceRefName=" + this.getInvoiceRefName() + ", invoiceRefAddressSuffix=" + this.getInvoiceRefAddressSuffix() + ", invoiceRefPoBox=" + this.getInvoiceRefPoBox() + ", invoiceRefStreet=" + this.getInvoiceRefStreet() + ", invoiceRefStreetNo=" + this.getInvoiceRefStreetNo() + ", invoiceRefZip=" + this.getInvoiceRefZip() + ", invoiceRefCity=" + this.getInvoiceRefCity() + ", invoiceRefCountry=" + this.getInvoiceRefCountry() + ", invoiceRefEmail=" + this.getInvoiceRefEmail() + ", invoiceRefPortal=" + this.getInvoiceRefPortal() + ", invoiceRefRemarks=" + this.getInvoiceRefRemarks() + ", additionalInfoHeader1=" + this.getAdditionalInfoHeader1() + ", additionalInfoDetail1=" + this.getAdditionalInfoDetail1() + ", additionalInfoHeader2=" + this.getAdditionalInfoHeader2() + ", additionalInfoDetail2=" + this.getAdditionalInfoDetail2() + ", additionalInfoHeader3=" + this.getAdditionalInfoHeader3() + ", additionalInfoDetail3=" + this.getAdditionalInfoDetail3() + ", attachments=" + this.getAttachments() + ", additionalAttachments=" + this.getAdditionalAttachments() + ", footerText=" + this.getFooterText() + ", financeCompanyNumber=" + this.getFinanceCompanyNumber() + ", financeAccountingText=" + this.getFinanceAccountingText() + ", financeTimeForPayment=" + this.getFinanceTimeForPayment() + ", financeCashDiscountTime1=" + this.getFinanceCashDiscountTime1() + ", financeCashDiscount1=" + String.valueOf(this.getFinanceCashDiscount1()) + ", financeCashDiscountTime2=" + this.getFinanceCashDiscountTime2() + ", financeCashDiscount2=" + String.valueOf(this.getFinanceCashDiscount2()) + ", financeDebtorAccountNumber=" + this.getFinanceDebtorAccountNumber() + ", financeTaxKeyValue=" + this.getFinanceTaxKeyValue() + ", financeAccount=" + this.getFinanceAccount() + ", financeRoutingReferenceId=" + this.getFinanceRoutingReferenceId() + ", subtotalWithoutDiscountValueNet=" + String.valueOf(this.getSubtotalWithoutDiscountValueNet()) + ", subtotalWithDiscountValueNet=" + String.valueOf(this.getSubtotalWithDiscountValueNet()) + ", totalDiscountValueNet=" + String.valueOf(this.getTotalDiscountValueNet()) + ", totalValueNet=" + String.valueOf(this.getTotalValueNet()) + ", totalValueGross=" + String.valueOf(this.getTotalValueGross()) + ", vatPercent=" + String.valueOf(this.getVatPercent()) + ", vatValue=" + String.valueOf(this.getVatValue()) + ", invoiceDueValueGross=" + String.valueOf(this.getInvoiceDueValueGross()) + ", flagSecurityRetention=" + this.getFlagSecurityRetention() + ", warrantySecurityRetentionPercent=" + String.valueOf(this.getWarrantySecurityRetentionPercent()) + ", warrantySecurityRetentionValue=" + String.valueOf(this.getWarrantySecurityRetentionValue()) + ", fulfillmentSecurityRetentionPercent=" + String.valueOf(this.getFulfillmentSecurityRetentionPercent()) + ", fulfillmentSecurityRetentionValue=" + String.valueOf(this.getFulfillmentSecurityRetentionValue()) + ", fulfillmentSecurityRetentionCumulativeValue=" + String.valueOf(this.getFulfillmentSecurityRetentionCumulativeValue()) + ", internalWageOverall=" + String.valueOf(this.getInternalWageOverall()) + ", squadWageOverall=" + String.valueOf(this.getSquadWageOverall()) + ", companyWageOverall=" + String.valueOf(this.getCompanyWageOverall()) + ", materialPurchasePriceOverall=" + String.valueOf(this.getMaterialPurchasePriceOverall()) + ", materialSellingPriceOverall=" + String.valueOf(this.getMaterialSellingPriceOverall()) + ", externalServicePurchasePriceOverall=" + String.valueOf(this.getExternalServicePurchasePriceOverall()) + ", externalServiceSellingPriceOverall=" + String.valueOf(this.getExternalServiceSellingPriceOverall()) + ", generalDiscount=" + String.valueOf(this.getGeneralDiscount()) + ", otherDiscount=" + String.valueOf(this.getOtherDiscount()) + ", expectedPDFValueOverallNet=" + String.valueOf(this.getExpectedPDFValueOverallNet()) + ", expectedPDFVAT=" + String.valueOf(this.getExpectedPDFVAT()) + ", expectedPDFValueOverallVAT=" + String.valueOf(this.getExpectedPDFValueOverallVAT()) + ", expectedPDFValueOverallGross=" + String.valueOf(this.getExpectedPDFValueOverallGross()) + ", expectedPDFCostCenter=" + this.getExpectedPDFCostCenter() + ", cancellationRemarks=" + this.getCancellationRemarks() + ", cancellationDebitNote=" + this.getCancellationDebitNote() + ", cancellationDate=" + (String.valueOf(this.getCancellationDate()) + ", cancellationPeriod=" + String.valueOf(this.getCancellationPeriod()) + ", importErrors=" + this.getImportErrors() + ", importFileName=" + this.getImportFileName() + ", measurementNumbers=" + this.getMeasurementNumbers() + ", er2ExportedOn=" + String.valueOf(this.getEr2ExportedOn()) + ", printedOn=" + String.valueOf(this.getPrintedOn()) + ", dmsExportState=" + String.valueOf(this.getDmsExportState()) + ", dmsExportedOn=" + String.valueOf(this.getDmsExportedOn()) + ", dmsExportedToPath=" + this.getDmsExportedToPath() + ", dmsExportedValue=" + String.valueOf(this.getDmsExportedValue()) + ", dmsCompanyGroupExportState=" + String.valueOf(this.getDmsCompanyGroupExportState()) + ", dmsCompanyGroupExportedOn=" + String.valueOf(this.getDmsCompanyGroupExportedOn()) + ", dmsCompanyGroupExportedToPath=" + this.getDmsCompanyGroupExportedToPath() + ", fileStoreExportState=" + String.valueOf(this.getFileStoreExportState()) + ", fileStoreExportedOn=" + String.valueOf(this.getFileStoreExportedOn()) + ", fileStoreExportedToPath=" + this.getFileStoreExportedToPath() + ", flagClosed=" + this.getFlagClosed() + ", closedOn=" + String.valueOf(this.getClosedOn()) + ", optionPrint13bParagraph=" + this.getOptionPrint13bParagraph() + ", optionPrintSubcontractorParagraph=" + this.getOptionPrintSubcontractorParagraph() + ", optionPrintStromnetzParagraph=" + this.getOptionPrintStromnetzParagraph() + ", optionCumulativePrint=" + this.getOptionCumulativePrint() + ", optionMeasurementPrint=" + this.getOptionMeasurementPrint() + ", optionMeasurementCumulativePrint=" + this.getOptionMeasurementCumulativePrint() + ", optionMeasurementCumulativePrintConsiderRemarks=" + this.getOptionMeasurementCumulativePrintConsiderRemarks() + ", optionIgnoreAddendum=" + this.getOptionIgnoreAddendum() + ")");
    }
}

