/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.invoice;

import com.google.common.collect.ImmutableMap;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.service.validator.Validator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EInvoiceSource implements Translatable
{
    UNKNOWN,
    SYNC,
    VOUCHER,
    MANUAL;

    private static final Map<String, EInvoiceSource> LOOKUP;

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EInvoiceSource lookup(@NonNull String candidate, @NonNull EInvoiceSource defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EInvoiceSource.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EInvoiceSource> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EInvoiceSource.key((String)candidate);
        return Optional.ofNullable((EInvoiceSource)LOOKUP.get(key));
    }

    @NonNull
    public static EInvoiceSource lookupFailing(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        Optional measurementViewTypeCandidate = EInvoiceSource.lookup((String)candidate);
        if (measurementViewTypeCandidate.isEmpty()) {
            throw Validator.throwEnumException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.INVOICE__SOURCE), (String)candidate, EInvoiceSource.class, EInvoiceSource::allowedKeys);
        }
        return (EInvoiceSource)measurementViewTypeCandidate.get();
    }

    @Nonnull
    private static String key(@NonNull EInvoiceSource item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return EInvoiceSource.key((String)item.name());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @Nonnull
    public String messageCode() {
        return "enum.invoice_source." + StringUtils.lowerCase((String)this.name());
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EInvoiceSource value : EInvoiceSource.values()) {
            String key = EInvoiceSource.key((EInvoiceSource)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
    }
}

