/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.history.type;

import com.google.common.collect.ImmutableMap;
import de.qfm.erp.service.model.internal.message.Translatable;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EEntityClass implements Translatable
{
    NONE("none"),
    CONSTRUCTION_SITE("construction_site"),
    CUSTOMER("customer"),
    INVOICE("invoice"),
    MEASUREMENT("measurement"),
    MEASUREMENT_REMARKS_TEMPLATE("measurement_remarks_template"),
    QUOTATION("quotation"),
    PAYROLL_MONTH("payroll_month"),
    PAYROLL_ITEM_TYPE("payroll_item_type"),
    SALUTATION("salutation"),
    SUB_PROJECT("sub_project"),
    USER("user"),
    AUTHORITY_TO_SIGN("authority_to_sign"),
    INVOICE_ATTACHMENT("invoice_attachment"),
    ARCHIVE_REASON("archive_reason"),
    STAGE("stage"),
    ENTITY("entity");

    private final String value;
    private static final Map<String, EEntityClass> LOOKUP;

    private EEntityClass(String value) {
        this.value = value;
    }

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EEntityClass lookup(@NonNull String candidate, @NonNull EEntityClass defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EEntityClass.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EEntityClass> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EEntityClass.key((String)candidate);
        return Optional.ofNullable((EEntityClass)LOOKUP.get(key));
    }

    @Nonnull
    private static String key(@NonNull EEntityClass eEntityClass) {
        if (eEntityClass == null) {
            throw new NullPointerException("eEntityClass is marked non-null but is null");
        }
        return EEntityClass.key((String)eEntityClass.getValue());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @Nonnull
    public String messageCode() {
        return "enum.entity_clazz." + StringUtils.lowerCase((String)this.name());
    }

    public String getValue() {
        return this.value;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EEntityClass value : EEntityClass.values()) {
            String key = EEntityClass.key((EEntityClass)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
    }
}

