/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.employee.payroll;

import de.qfm.erp.service.helper.NullStringConverter;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.businessunit.BusinessUnit;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionContract;
import de.qfm.erp.service.model.jpa.employee.payroll.EPayrollMonthState;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonthItem;
import de.qfm.erp.service.model.jpa.user.User;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

@Entity(name="PayrollMonth")
@Table(name="PAYROLL_MONTH")
public class PayrollMonth
extends EntityBase {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PAYROLL_MONTH_SEQ")
    @SequenceGenerator(sequenceName="PAYROLL_MONTH_SEQ", allocationSize=1, name="PAYROLL_MONTH_SEQ")
    private Long id;
    @Column(name="reference_id", length=50)
    private String referenceId;
    @Enumerated(value=EnumType.STRING)
    @Column(name="payroll_month_state", length=50)
    private EPayrollMonthState payrollMonthState;
    @JoinColumn(name="manager_id")
    @ManyToOne(optional=true)
    private User manager;
    @JoinColumn(name="user_id")
    @ManyToOne(optional=true)
    private User user;
    @Deprecated
    @Column(name="personal_number")
    private Integer personalNumber;
    @Column(name="accounting_month")
    private LocalDate accountingMonth;
    @Column(name="cost_center", length=15)
    @Convert(converter=NullStringConverter.class)
    private String costCenter;
    @Column(name="remarks", length=250)
    @Convert(converter=NullStringConverter.class)
    private String remarks;
    @JoinColumn(name="release_user_id")
    @ManyToOne(optional=true)
    private User releasedBy;
    @Column(name="released_on")
    private LocalDateTime releasedOn;
    @JoinColumn(name="export_user_id")
    @ManyToOne(optional=true)
    private User exportedBy;
    @Column(name="exported_on")
    private LocalDateTime exportedOn;
    @JoinColumn(name="slip_printed_by_user_id")
    @ManyToOne(optional=true)
    private User slipPrintedBy;
    @Column(name="slip_printed_on")
    private LocalDateTime slipPrintedOn;
    @Column(name="current_wage")
    private BigDecimal currentWage;
    @Column(name="exported_wage")
    private BigDecimal exportedWage;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="labor_union_contract_id")
    private LaborUnionContract laborUnionContract;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="business_unit_id")
    private BusinessUnit businessUnit;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="payrollMonth", cascade={CascadeType.ALL})
    private List<Attendance> attendances;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="payrollMonth", cascade={CascadeType.ALL})
    private List<PayrollMonthItem> payrollMonthItems;

    public Long getId() {
        return this.id;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public EPayrollMonthState getPayrollMonthState() {
        return this.payrollMonthState;
    }

    public User getManager() {
        return this.manager;
    }

    public User getUser() {
        return this.user;
    }

    @Deprecated
    public Integer getPersonalNumber() {
        return this.personalNumber;
    }

    public LocalDate getAccountingMonth() {
        return this.accountingMonth;
    }

    public String getCostCenter() {
        return this.costCenter;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public User getReleasedBy() {
        return this.releasedBy;
    }

    public LocalDateTime getReleasedOn() {
        return this.releasedOn;
    }

    public User getExportedBy() {
        return this.exportedBy;
    }

    public LocalDateTime getExportedOn() {
        return this.exportedOn;
    }

    public User getSlipPrintedBy() {
        return this.slipPrintedBy;
    }

    public LocalDateTime getSlipPrintedOn() {
        return this.slipPrintedOn;
    }

    public BigDecimal getCurrentWage() {
        return this.currentWage;
    }

    public BigDecimal getExportedWage() {
        return this.exportedWage;
    }

    public LaborUnionContract getLaborUnionContract() {
        return this.laborUnionContract;
    }

    public BusinessUnit getBusinessUnit() {
        return this.businessUnit;
    }

    public List<Attendance> getAttendances() {
        return this.attendances;
    }

    public List<PayrollMonthItem> getPayrollMonthItems() {
        return this.payrollMonthItems;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public void setPayrollMonthState(EPayrollMonthState payrollMonthState) {
        this.payrollMonthState = payrollMonthState;
    }

    public void setManager(User manager) {
        this.manager = manager;
    }

    public void setUser(User user) {
        this.user = user;
    }

    @Deprecated
    public void setPersonalNumber(Integer personalNumber) {
        this.personalNumber = personalNumber;
    }

    public void setAccountingMonth(LocalDate accountingMonth) {
        this.accountingMonth = accountingMonth;
    }

    public void setCostCenter(String costCenter) {
        this.costCenter = costCenter;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public void setReleasedBy(User releasedBy) {
        this.releasedBy = releasedBy;
    }

    public void setReleasedOn(LocalDateTime releasedOn) {
        this.releasedOn = releasedOn;
    }

    public void setExportedBy(User exportedBy) {
        this.exportedBy = exportedBy;
    }

    public void setExportedOn(LocalDateTime exportedOn) {
        this.exportedOn = exportedOn;
    }

    public void setSlipPrintedBy(User slipPrintedBy) {
        this.slipPrintedBy = slipPrintedBy;
    }

    public void setSlipPrintedOn(LocalDateTime slipPrintedOn) {
        this.slipPrintedOn = slipPrintedOn;
    }

    public void setCurrentWage(BigDecimal currentWage) {
        this.currentWage = currentWage;
    }

    public void setExportedWage(BigDecimal exportedWage) {
        this.exportedWage = exportedWage;
    }

    public void setLaborUnionContract(LaborUnionContract laborUnionContract) {
        this.laborUnionContract = laborUnionContract;
    }

    public void setBusinessUnit(BusinessUnit businessUnit) {
        this.businessUnit = businessUnit;
    }

    public void setAttendances(List<Attendance> attendances) {
        this.attendances = attendances;
    }

    public void setPayrollMonthItems(List<PayrollMonthItem> payrollMonthItems) {
        this.payrollMonthItems = payrollMonthItems;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PayrollMonth)) {
            return false;
        }
        PayrollMonth other = (PayrollMonth)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$personalNumber = this.getPersonalNumber();
        Integer other$personalNumber = other.getPersonalNumber();
        if (this$personalNumber == null ? other$personalNumber != null : !((Object)this$personalNumber).equals(other$personalNumber)) {
            return false;
        }
        String this$referenceId = this.getReferenceId();
        String other$referenceId = other.getReferenceId();
        if (this$referenceId == null ? other$referenceId != null : !this$referenceId.equals(other$referenceId)) {
            return false;
        }
        EPayrollMonthState this$payrollMonthState = this.getPayrollMonthState();
        EPayrollMonthState other$payrollMonthState = other.getPayrollMonthState();
        if (this$payrollMonthState == null ? other$payrollMonthState != null : !this$payrollMonthState.equals(other$payrollMonthState)) {
            return false;
        }
        LocalDate this$accountingMonth = this.getAccountingMonth();
        LocalDate other$accountingMonth = other.getAccountingMonth();
        if (this$accountingMonth == null ? other$accountingMonth != null : !((Object)this$accountingMonth).equals(other$accountingMonth)) {
            return false;
        }
        String this$costCenter = this.getCostCenter();
        String other$costCenter = other.getCostCenter();
        if (this$costCenter == null ? other$costCenter != null : !this$costCenter.equals(other$costCenter)) {
            return false;
        }
        String this$remarks = this.getRemarks();
        String other$remarks = other.getRemarks();
        if (this$remarks == null ? other$remarks != null : !this$remarks.equals(other$remarks)) {
            return false;
        }
        LocalDateTime this$releasedOn = this.getReleasedOn();
        LocalDateTime other$releasedOn = other.getReleasedOn();
        if (this$releasedOn == null ? other$releasedOn != null : !((Object)this$releasedOn).equals(other$releasedOn)) {
            return false;
        }
        LocalDateTime this$exportedOn = this.getExportedOn();
        LocalDateTime other$exportedOn = other.getExportedOn();
        if (this$exportedOn == null ? other$exportedOn != null : !((Object)this$exportedOn).equals(other$exportedOn)) {
            return false;
        }
        LocalDateTime this$slipPrintedOn = this.getSlipPrintedOn();
        LocalDateTime other$slipPrintedOn = other.getSlipPrintedOn();
        if (this$slipPrintedOn == null ? other$slipPrintedOn != null : !((Object)this$slipPrintedOn).equals(other$slipPrintedOn)) {
            return false;
        }
        BigDecimal this$currentWage = this.getCurrentWage();
        BigDecimal other$currentWage = other.getCurrentWage();
        if (this$currentWage == null ? other$currentWage != null : !((Object)this$currentWage).equals(other$currentWage)) {
            return false;
        }
        BigDecimal this$exportedWage = this.getExportedWage();
        BigDecimal other$exportedWage = other.getExportedWage();
        return !(this$exportedWage == null ? other$exportedWage != null : !((Object)this$exportedWage).equals(other$exportedWage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PayrollMonth;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $personalNumber = this.getPersonalNumber();
        result = result * 59 + ($personalNumber == null ? 43 : ((Object)$personalNumber).hashCode());
        String $referenceId = this.getReferenceId();
        result = result * 59 + ($referenceId == null ? 43 : $referenceId.hashCode());
        EPayrollMonthState $payrollMonthState = this.getPayrollMonthState();
        result = result * 59 + ($payrollMonthState == null ? 43 : $payrollMonthState.hashCode());
        LocalDate $accountingMonth = this.getAccountingMonth();
        result = result * 59 + ($accountingMonth == null ? 43 : ((Object)$accountingMonth).hashCode());
        String $costCenter = this.getCostCenter();
        result = result * 59 + ($costCenter == null ? 43 : $costCenter.hashCode());
        String $remarks = this.getRemarks();
        result = result * 59 + ($remarks == null ? 43 : $remarks.hashCode());
        LocalDateTime $releasedOn = this.getReleasedOn();
        result = result * 59 + ($releasedOn == null ? 43 : ((Object)$releasedOn).hashCode());
        LocalDateTime $exportedOn = this.getExportedOn();
        result = result * 59 + ($exportedOn == null ? 43 : ((Object)$exportedOn).hashCode());
        LocalDateTime $slipPrintedOn = this.getSlipPrintedOn();
        result = result * 59 + ($slipPrintedOn == null ? 43 : ((Object)$slipPrintedOn).hashCode());
        BigDecimal $currentWage = this.getCurrentWage();
        result = result * 59 + ($currentWage == null ? 43 : ((Object)$currentWage).hashCode());
        BigDecimal $exportedWage = this.getExportedWage();
        result = result * 59 + ($exportedWage == null ? 43 : ((Object)$exportedWage).hashCode());
        return result;
    }

    public String toString() {
        return "PayrollMonth(super=" + super.toString() + ", id=" + this.getId() + ", referenceId=" + this.getReferenceId() + ", payrollMonthState=" + String.valueOf(this.getPayrollMonthState()) + ", personalNumber=" + this.getPersonalNumber() + ", accountingMonth=" + String.valueOf(this.getAccountingMonth()) + ", costCenter=" + this.getCostCenter() + ", remarks=" + this.getRemarks() + ", releasedOn=" + String.valueOf(this.getReleasedOn()) + ", exportedOn=" + String.valueOf(this.getExportedOn()) + ", slipPrintedOn=" + String.valueOf(this.getSlipPrintedOn()) + ", currentWage=" + String.valueOf(this.getCurrentWage()) + ", exportedWage=" + String.valueOf(this.getExportedWage()) + ")";
    }
}

