/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.employee.payroll;

import de.qfm.erp.service.helper.NullStringConverter;
import de.qfm.erp.service.model.internal.employee.payroll.EDurationType;
import de.qfm.erp.service.model.internal.employee.payroll.EWageAccountOn;
import de.qfm.erp.service.model.internal.employee.payroll.EWageTypeCalculationResultType;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionContract;
import de.qfm.erp.service.model.jpa.employee.payroll.EPayrollItemUnit;
import de.qfm.erp.service.service.calculator.wagetype.EWageType;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.util.Objects;
import org.hibernate.Hibernate;

@Entity(name="PayrollItemType")
@Table(name="PAYROLL_ITEM_TYPE")
public class PayrollItemType
extends EntityBase {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PAYROLL_ITEM_TYPE_SEQ")
    @SequenceGenerator(sequenceName="PAYROLL_ITEM_TYPE_SEQ", allocationSize=1, name="PAYROLL_ITEM_TYPE_SEQ")
    private Long id;
    @JoinColumn(name="labor_union_contract_id")
    @ManyToOne(optional=true)
    private LaborUnionContract laborUnionContract;
    @Enumerated(value=EnumType.STRING)
    @Column(name="unit", length=50)
    private EPayrollItemUnit unit;
    @Column(name="name", length=50)
    @Convert(converter=NullStringConverter.class)
    private String name;
    @Column(name="description", length=200)
    @Convert(converter=NullStringConverter.class)
    private String description;
    @Column(name="value")
    private BigDecimal value;
    @Column(name="flag_visible_in_selection")
    private Boolean flagVisibleInSelection;
    @Enumerated(value=EnumType.STRING)
    @Column(name="wage_type", length=50)
    private EWageType wageType;
    @Column(name="wage_type_number")
    private Integer wageTypeNumber;
    @Column(name="flag_deduct_from_wage")
    private Boolean flagDeductFromWage;
    @JoinColumn(name="sbs_value_payroll_item_type_id")
    @ManyToOne(fetch=FetchType.EAGER)
    private PayrollItemType sbsValuePayrollItemType;
    @Column(name="sequential_number")
    private Integer sequentialNumber;
    @Column(name="flag_print_row")
    private Boolean flagPrintRow;
    @Column(name="flag_print_times")
    private Boolean flagPrintTimes;
    @Column(name="flag_print_factor")
    private Boolean flagPrintFactor;
    @Column(name="flag_print_value")
    private Boolean flagPrintValue;
    @Column(name="flag_print_detail_times")
    private Boolean flagPrintDetailTimes;
    @Column(name="flag_print_detail_factor")
    private Boolean flagPrintDetailFactor;
    @Column(name="flag_print_detail_value")
    private Boolean flagPrintDetailValue;
    @Column(name="flag_sbs_export_times")
    private Boolean flagSBSExportTimes;
    @Column(name="flag_sbs_export_factor")
    private Boolean flagSBSExportFactor;
    @Column(name="flag_sbs_export_value")
    private Boolean flagSBSExportValue;
    @Column(name="flag_attendance_report_agg")
    private Boolean flagAttendanceReportAggregation;
    @Enumerated(value=EnumType.STRING)
    @Column(name="sbs_wage_calc_type")
    private EWageTypeCalculationResultType sbsExportWageTypeCalculationResultType;
    @Enumerated(value=EnumType.STRING)
    @Column(name="print_wage_calc_type")
    private EWageTypeCalculationResultType printWageTypeCalculationResultType;
    @Enumerated(value=EnumType.STRING)
    @Column(name="sbs_wage_account_on")
    private EWageAccountOn sbsWageAccountOn;
    @Enumerated(value=EnumType.STRING)
    @Column(name="sbs_duration_output_type")
    private EDurationType sbsDurationOutputType;
    @Column(name="flag_remarks_mandatory")
    private Boolean flagRemarksMandatory;
    @Column(name="flag_project_mandatory")
    private Boolean flagProjectMandatory;
    @Column(name="flag_remarks_from_dictionary")
    private Boolean flagRemarksFromDictionary;
    @Column(name="flag_monthly_report_exclude")
    private Boolean flagMonthlyReportExclude;
    @Column(name="flag_project_based_wage_export_include")
    private Boolean flagProjectBasedWageExportInclude;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass((Object)this) != Hibernate.getClass((Object)o)) {
            return false;
        }
        PayrollItemType that = (PayrollItemType)o;
        return this.id != null && Objects.equals(this.id, that.getId());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public Long getId() {
        return this.id;
    }

    public LaborUnionContract getLaborUnionContract() {
        return this.laborUnionContract;
    }

    public EPayrollItemUnit getUnit() {
        return this.unit;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public Boolean getFlagVisibleInSelection() {
        return this.flagVisibleInSelection;
    }

    public EWageType getWageType() {
        return this.wageType;
    }

    public Integer getWageTypeNumber() {
        return this.wageTypeNumber;
    }

    public Boolean getFlagDeductFromWage() {
        return this.flagDeductFromWage;
    }

    public PayrollItemType getSbsValuePayrollItemType() {
        return this.sbsValuePayrollItemType;
    }

    public Integer getSequentialNumber() {
        return this.sequentialNumber;
    }

    public Boolean getFlagPrintRow() {
        return this.flagPrintRow;
    }

    public Boolean getFlagPrintTimes() {
        return this.flagPrintTimes;
    }

    public Boolean getFlagPrintFactor() {
        return this.flagPrintFactor;
    }

    public Boolean getFlagPrintValue() {
        return this.flagPrintValue;
    }

    public Boolean getFlagPrintDetailTimes() {
        return this.flagPrintDetailTimes;
    }

    public Boolean getFlagPrintDetailFactor() {
        return this.flagPrintDetailFactor;
    }

    public Boolean getFlagPrintDetailValue() {
        return this.flagPrintDetailValue;
    }

    public Boolean getFlagSBSExportTimes() {
        return this.flagSBSExportTimes;
    }

    public Boolean getFlagSBSExportFactor() {
        return this.flagSBSExportFactor;
    }

    public Boolean getFlagSBSExportValue() {
        return this.flagSBSExportValue;
    }

    public Boolean getFlagAttendanceReportAggregation() {
        return this.flagAttendanceReportAggregation;
    }

    public EWageTypeCalculationResultType getSbsExportWageTypeCalculationResultType() {
        return this.sbsExportWageTypeCalculationResultType;
    }

    public EWageTypeCalculationResultType getPrintWageTypeCalculationResultType() {
        return this.printWageTypeCalculationResultType;
    }

    public EWageAccountOn getSbsWageAccountOn() {
        return this.sbsWageAccountOn;
    }

    public EDurationType getSbsDurationOutputType() {
        return this.sbsDurationOutputType;
    }

    public Boolean getFlagRemarksMandatory() {
        return this.flagRemarksMandatory;
    }

    public Boolean getFlagProjectMandatory() {
        return this.flagProjectMandatory;
    }

    public Boolean getFlagRemarksFromDictionary() {
        return this.flagRemarksFromDictionary;
    }

    public Boolean getFlagMonthlyReportExclude() {
        return this.flagMonthlyReportExclude;
    }

    public Boolean getFlagProjectBasedWageExportInclude() {
        return this.flagProjectBasedWageExportInclude;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setLaborUnionContract(LaborUnionContract laborUnionContract) {
        this.laborUnionContract = laborUnionContract;
    }

    public void setUnit(EPayrollItemUnit unit) {
        this.unit = unit;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    public void setFlagVisibleInSelection(Boolean flagVisibleInSelection) {
        this.flagVisibleInSelection = flagVisibleInSelection;
    }

    public void setWageType(EWageType wageType) {
        this.wageType = wageType;
    }

    public void setWageTypeNumber(Integer wageTypeNumber) {
        this.wageTypeNumber = wageTypeNumber;
    }

    public void setFlagDeductFromWage(Boolean flagDeductFromWage) {
        this.flagDeductFromWage = flagDeductFromWage;
    }

    public void setSbsValuePayrollItemType(PayrollItemType sbsValuePayrollItemType) {
        this.sbsValuePayrollItemType = sbsValuePayrollItemType;
    }

    public void setSequentialNumber(Integer sequentialNumber) {
        this.sequentialNumber = sequentialNumber;
    }

    public void setFlagPrintRow(Boolean flagPrintRow) {
        this.flagPrintRow = flagPrintRow;
    }

    public void setFlagPrintTimes(Boolean flagPrintTimes) {
        this.flagPrintTimes = flagPrintTimes;
    }

    public void setFlagPrintFactor(Boolean flagPrintFactor) {
        this.flagPrintFactor = flagPrintFactor;
    }

    public void setFlagPrintValue(Boolean flagPrintValue) {
        this.flagPrintValue = flagPrintValue;
    }

    public void setFlagPrintDetailTimes(Boolean flagPrintDetailTimes) {
        this.flagPrintDetailTimes = flagPrintDetailTimes;
    }

    public void setFlagPrintDetailFactor(Boolean flagPrintDetailFactor) {
        this.flagPrintDetailFactor = flagPrintDetailFactor;
    }

    public void setFlagPrintDetailValue(Boolean flagPrintDetailValue) {
        this.flagPrintDetailValue = flagPrintDetailValue;
    }

    public void setFlagSBSExportTimes(Boolean flagSBSExportTimes) {
        this.flagSBSExportTimes = flagSBSExportTimes;
    }

    public void setFlagSBSExportFactor(Boolean flagSBSExportFactor) {
        this.flagSBSExportFactor = flagSBSExportFactor;
    }

    public void setFlagSBSExportValue(Boolean flagSBSExportValue) {
        this.flagSBSExportValue = flagSBSExportValue;
    }

    public void setFlagAttendanceReportAggregation(Boolean flagAttendanceReportAggregation) {
        this.flagAttendanceReportAggregation = flagAttendanceReportAggregation;
    }

    public void setSbsExportWageTypeCalculationResultType(EWageTypeCalculationResultType sbsExportWageTypeCalculationResultType) {
        this.sbsExportWageTypeCalculationResultType = sbsExportWageTypeCalculationResultType;
    }

    public void setPrintWageTypeCalculationResultType(EWageTypeCalculationResultType printWageTypeCalculationResultType) {
        this.printWageTypeCalculationResultType = printWageTypeCalculationResultType;
    }

    public void setSbsWageAccountOn(EWageAccountOn sbsWageAccountOn) {
        this.sbsWageAccountOn = sbsWageAccountOn;
    }

    public void setSbsDurationOutputType(EDurationType sbsDurationOutputType) {
        this.sbsDurationOutputType = sbsDurationOutputType;
    }

    public void setFlagRemarksMandatory(Boolean flagRemarksMandatory) {
        this.flagRemarksMandatory = flagRemarksMandatory;
    }

    public void setFlagProjectMandatory(Boolean flagProjectMandatory) {
        this.flagProjectMandatory = flagProjectMandatory;
    }

    public void setFlagRemarksFromDictionary(Boolean flagRemarksFromDictionary) {
        this.flagRemarksFromDictionary = flagRemarksFromDictionary;
    }

    public void setFlagMonthlyReportExclude(Boolean flagMonthlyReportExclude) {
        this.flagMonthlyReportExclude = flagMonthlyReportExclude;
    }

    public void setFlagProjectBasedWageExportInclude(Boolean flagProjectBasedWageExportInclude) {
        this.flagProjectBasedWageExportInclude = flagProjectBasedWageExportInclude;
    }

    public String toString() {
        return "PayrollItemType(super=" + super.toString() + ", id=" + this.getId() + ", unit=" + String.valueOf(this.getUnit()) + ", name=" + this.getName() + ", description=" + this.getDescription() + ", value=" + String.valueOf(this.getValue()) + ", flagVisibleInSelection=" + this.getFlagVisibleInSelection() + ", wageType=" + String.valueOf(this.getWageType()) + ", wageTypeNumber=" + this.getWageTypeNumber() + ", flagDeductFromWage=" + this.getFlagDeductFromWage() + ", sequentialNumber=" + this.getSequentialNumber() + ", flagPrintRow=" + this.getFlagPrintRow() + ", flagPrintTimes=" + this.getFlagPrintTimes() + ", flagPrintFactor=" + this.getFlagPrintFactor() + ", flagPrintValue=" + this.getFlagPrintValue() + ", flagPrintDetailTimes=" + this.getFlagPrintDetailTimes() + ", flagPrintDetailFactor=" + this.getFlagPrintDetailFactor() + ", flagPrintDetailValue=" + this.getFlagPrintDetailValue() + ", flagSBSExportTimes=" + this.getFlagSBSExportTimes() + ", flagSBSExportFactor=" + this.getFlagSBSExportFactor() + ", flagSBSExportValue=" + this.getFlagSBSExportValue() + ", flagAttendanceReportAggregation=" + this.getFlagAttendanceReportAggregation() + ", sbsExportWageTypeCalculationResultType=" + String.valueOf(this.getSbsExportWageTypeCalculationResultType()) + ", printWageTypeCalculationResultType=" + String.valueOf(this.getPrintWageTypeCalculationResultType()) + ", sbsWageAccountOn=" + String.valueOf(this.getSbsWageAccountOn()) + ", sbsDurationOutputType=" + String.valueOf(this.getSbsDurationOutputType()) + ", flagRemarksMandatory=" + this.getFlagRemarksMandatory() + ", flagProjectMandatory=" + this.getFlagProjectMandatory() + ", flagRemarksFromDictionary=" + this.getFlagRemarksFromDictionary() + ", flagMonthlyReportExclude=" + this.getFlagMonthlyReportExclude() + ", flagProjectBasedWageExportInclude=" + this.getFlagProjectBasedWageExportInclude() + ")";
    }
}

