/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.employee.payroll;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonthItem;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EPayrollItemClazz implements Translatable
{
    UNKNOWN,
    AUXILIARY_WAGE,
    INCENTIVE_PAYMENT,
    WAGE_ACCOUNT;

    private static final Map<String, EPayrollItemClazz> LOOKUP;
    @Nonnull
    public static final Iterable<EPayrollItemClazz> PAYOUT_CONSIDER_INCENTIVE;
    public static final Predicate<PayrollMonthItem> INCENTIVE_PREDICATE;

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EPayrollItemClazz lookup(@NonNull String candidate, @NonNull EPayrollItemClazz defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EPayrollItemClazz.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EPayrollItemClazz> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EPayrollItemClazz.key((String)candidate);
        return Optional.ofNullable((EPayrollItemClazz)LOOKUP.get(key));
    }

    @Nonnull
    private static String key(@NonNull EPayrollItemClazz item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return EPayrollItemClazz.key((String)item.name());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @Nonnull
    public String messageCode() {
        return "enum.payroll_item_clazz." + EPayrollItemClazz.key((EPayrollItemClazz)this);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EPayrollItemClazz value : EPayrollItemClazz.values()) {
            String key = EPayrollItemClazz.key((EPayrollItemClazz)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
        PAYOUT_CONSIDER_INCENTIVE = ImmutableSet.of((Object)INCENTIVE_PAYMENT, (Object)WAGE_ACCOUNT, (Object)AUXILIARY_WAGE);
        INCENTIVE_PREDICATE = item -> Iterables.contains((Iterable)PAYOUT_CONSIDER_INCENTIVE, (Object)item.getPayrollItemClazz());
    }
}

