/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.jpa.customer;

import com.google.common.collect.ImmutableMap;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.service.validator.Validator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EAddressType implements Translatable
{
    UNKNOWN,
    PRIMARY,
    SECONDARY,
    AGENT,
    INVOICE,
    QUOTATION;

    private static final Map<String, EAddressType> LOOKUP;

    @Nonnull
    public static Collection<String> allowedKeys() {
        return LOOKUP.keySet();
    }

    @NonNull
    public static EAddressType lookup(@NonNull String candidate, @NonNull EAddressType defaultValue) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        return EAddressType.lookup((String)candidate).orElse(defaultValue);
    }

    @NonNull
    public static Optional<EAddressType> lookup(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        String key = EAddressType.key((String)candidate);
        return Optional.ofNullable((EAddressType)LOOKUP.get(key));
    }

    @NonNull
    public static EAddressType lookupFailing(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        Optional measurementViewTypeCandidate = EAddressType.lookup((String)candidate);
        if (measurementViewTypeCandidate.isEmpty()) {
            throw Validator.throwEnumException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.INVOICE__INVOICE_TYPE), (String)candidate, EAddressType.class, EAddressType::allowedKeys);
        }
        return (EAddressType)measurementViewTypeCandidate.get();
    }

    @Nonnull
    private static String key(@NonNull EAddressType item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return EAddressType.key((String)item.name());
    }

    @Nonnull
    private static String key(@NonNull String candidate) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        return StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)candidate));
    }

    @Nonnull
    public String messageCode() {
        return "enum.address_type." + EAddressType.key((EAddressType)this);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EAddressType value : EAddressType.values()) {
            String key = EAddressType.key((EAddressType)value);
            builder.put((Object)key, (Object)value);
        }
        LOOKUP = builder.build();
    }
}

