/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.xlsx;

import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.streaming.SXSSFSheet;

public class CellStyles {
    @NonNull
    private final CellStyle header;
    @NonNull
    private final CellStyle text;
    @NonNull
    private final CellStyle decimal0;
    @NonNull
    private final CellStyle decimal2;
    @NonNull
    private final CellStyle formula;
    private static final short HSSF_DECIMAL2_FORMAT = HSSFDataFormat.getBuiltinFormat((String)"#,##0.00");
    private static final short HSSF_DECIMAL0_FORMAT = HSSFDataFormat.getBuiltinFormat((String)"#0");
    private static final short CELL_STYLE_FORMULA_NUMBER_FORMAT = HSSFDataFormat.getBuiltinFormat((String)"#,##0.00");

    @Nonnull
    public static CellStyle decimal0CellStyle(@NonNull SXSSFSheet sheet, @NonNull CellStyle origin) {
        if (sheet == null) {
            throw new NullPointerException("sheet is marked non-null but is null");
        }
        if (origin == null) {
            throw new NullPointerException("origin is marked non-null but is null");
        }
        CellStyle cellStyle = sheet.getWorkbook().createCellStyle();
        cellStyle.cloneStyleFrom(origin);
        cellStyle.setDataFormat(HSSF_DECIMAL0_FORMAT);
        return cellStyle;
    }

    @Nonnull
    public static CellStyle decimal2CellStyle(@NonNull SXSSFSheet sheet, @NonNull CellStyle origin) {
        if (sheet == null) {
            throw new NullPointerException("sheet is marked non-null but is null");
        }
        if (origin == null) {
            throw new NullPointerException("origin is marked non-null but is null");
        }
        CellStyle cellStyle = sheet.getWorkbook().createCellStyle();
        cellStyle.cloneStyleFrom(origin);
        cellStyle.setDataFormat(HSSF_DECIMAL2_FORMAT);
        return cellStyle;
    }

    @Nonnull
    public static CellStyle formulaCellStyle(@NonNull SXSSFSheet sheet, @NonNull CellStyle origin) {
        if (sheet == null) {
            throw new NullPointerException("sheet is marked non-null but is null");
        }
        if (origin == null) {
            throw new NullPointerException("origin is marked non-null but is null");
        }
        CellStyle cellStyle = sheet.getWorkbook().createCellStyle();
        cellStyle.cloneStyleFrom(origin);
        cellStyle.setDataFormat(CELL_STYLE_FORMULA_NUMBER_FORMAT);
        return cellStyle;
    }

    private CellStyles(@NonNull CellStyle header, @NonNull CellStyle text, @NonNull CellStyle decimal0, @NonNull CellStyle decimal2, @NonNull CellStyle formula) {
        if (header == null) {
            throw new NullPointerException("header is marked non-null but is null");
        }
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (decimal0 == null) {
            throw new NullPointerException("decimal0 is marked non-null but is null");
        }
        if (decimal2 == null) {
            throw new NullPointerException("decimal2 is marked non-null but is null");
        }
        if (formula == null) {
            throw new NullPointerException("formula is marked non-null but is null");
        }
        this.header = header;
        this.text = text;
        this.decimal0 = decimal0;
        this.decimal2 = decimal2;
        this.formula = formula;
    }

    public static CellStyles create(@NonNull CellStyle header, @NonNull CellStyle text, @NonNull CellStyle decimal0, @NonNull CellStyle decimal2, @NonNull CellStyle formula) {
        if (header == null) {
            throw new NullPointerException("header is marked non-null but is null");
        }
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (decimal0 == null) {
            throw new NullPointerException("decimal0 is marked non-null but is null");
        }
        if (decimal2 == null) {
            throw new NullPointerException("decimal2 is marked non-null but is null");
        }
        if (formula == null) {
            throw new NullPointerException("formula is marked non-null but is null");
        }
        return new CellStyles(header, text, decimal0, decimal2, formula);
    }

    @NonNull
    public CellStyle getHeader() {
        return this.header;
    }

    @NonNull
    public CellStyle getText() {
        return this.text;
    }

    @NonNull
    public CellStyle getDecimal0() {
        return this.decimal0;
    }

    @NonNull
    public CellStyle getDecimal2() {
        return this.decimal2;
    }

    @NonNull
    public CellStyle getFormula() {
        return this.formula;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CellStyles)) {
            return false;
        }
        CellStyles other = (CellStyles)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        CellStyle this$header = this.getHeader();
        CellStyle other$header = other.getHeader();
        if (this$header == null ? other$header != null : !this$header.equals(other$header)) {
            return false;
        }
        CellStyle this$text = this.getText();
        CellStyle other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        CellStyle this$decimal0 = this.getDecimal0();
        CellStyle other$decimal0 = other.getDecimal0();
        if (this$decimal0 == null ? other$decimal0 != null : !this$decimal0.equals(other$decimal0)) {
            return false;
        }
        CellStyle this$decimal2 = this.getDecimal2();
        CellStyle other$decimal2 = other.getDecimal2();
        if (this$decimal2 == null ? other$decimal2 != null : !this$decimal2.equals(other$decimal2)) {
            return false;
        }
        CellStyle this$formula = this.getFormula();
        CellStyle other$formula = other.getFormula();
        return !(this$formula == null ? other$formula != null : !this$formula.equals(other$formula));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CellStyles;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CellStyle $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : $header.hashCode());
        CellStyle $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        CellStyle $decimal0 = this.getDecimal0();
        result = result * 59 + ($decimal0 == null ? 43 : $decimal0.hashCode());
        CellStyle $decimal2 = this.getDecimal2();
        result = result * 59 + ($decimal2 == null ? 43 : $decimal2.hashCode());
        CellStyle $formula = this.getFormula();
        result = result * 59 + ($formula == null ? 43 : $formula.hashCode());
        return result;
    }

    public String toString() {
        return "CellStyles(header=" + String.valueOf(this.getHeader()) + ", text=" + String.valueOf(this.getText()) + ", decimal0=" + String.valueOf(this.getDecimal0()) + ", decimal2=" + String.valueOf(this.getDecimal2()) + ", formula=" + String.valueOf(this.getFormula()) + ")";
    }
}

