/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.print.measurement;

import com.google.common.base.Objects;
import de.qfm.erp.service.model.jpa.shared.EPositionType;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import lombok.NonNull;

public class TransposedItem {
    public static final TransposedItem EMPTY = TransposedItem.empty();
    private EPositionType positionType;
    private String quotationPositionNumber;
    private Integer quotationSubPositionNumber;
    private String quotationSurrogatePositionNumber;
    private BigDecimal amount;
    private BigDecimal product;
    private String remark;
    private String unit;
    private String shortText;
    private String longText;
    private BigDecimal internalSquadWagePerUnit;
    private BigDecimal internalSquadWageAggregated;

    @Nonnull
    private static TransposedItem empty() {
        TransposedItem item = new TransposedItem();
        item.setPositionType(EPositionType.UNKNOWN);
        item.setQuotationPositionNumber("");
        item.setQuotationSubPositionNumber(null);
        item.setAmount(null);
        item.setRemark("");
        item.setUnit("");
        item.setShortText("");
        item.setLongText("");
        item.setInternalSquadWagePerUnit(BigDecimal.ZERO);
        item.setInternalSquadWageAggregated(BigDecimal.ZERO);
        return item;
    }

    @Nonnull
    public TransposedItem merge(@NonNull TransposedItem that) {
        if (that == null) {
            throw new NullPointerException("that is marked non-null but is null");
        }
        if (Objects.equal((Object)this.quotationSurrogatePositionNumber, (Object)that.quotationSurrogatePositionNumber)) {
            TransposedItem transposedItemMerged = new TransposedItem();
            BigDecimal amountMerged = null != this.amount && null != that.amount ? this.amount.add(that.amount) : (null != this.amount ? this.amount : (null != that.amount ? that.amount : null));
            BigDecimal productMerged = null != this.product && null != that.product ? this.product.add(that.product) : (null != this.product ? this.product : (null != that.product ? that.product : null));
            transposedItemMerged.setPositionType(this.positionType);
            transposedItemMerged.setQuotationPositionNumber(this.quotationPositionNumber);
            transposedItemMerged.setQuotationSubPositionNumber(this.quotationSubPositionNumber);
            transposedItemMerged.setQuotationSurrogatePositionNumber(this.quotationSurrogatePositionNumber);
            transposedItemMerged.setAmount(amountMerged);
            transposedItemMerged.setProduct(productMerged);
            transposedItemMerged.setRemark(this.remark);
            transposedItemMerged.setUnit(this.unit);
            transposedItemMerged.setShortText(this.shortText);
            transposedItemMerged.setLongText(this.longText);
            transposedItemMerged.setInternalSquadWagePerUnit(this.internalSquadWagePerUnit);
            transposedItemMerged.setInternalSquadWageAggregated(this.internalSquadWageAggregated);
            return transposedItemMerged;
        }
        return this;
    }

    public EPositionType getPositionType() {
        return this.positionType;
    }

    public String getQuotationPositionNumber() {
        return this.quotationPositionNumber;
    }

    public Integer getQuotationSubPositionNumber() {
        return this.quotationSubPositionNumber;
    }

    public String getQuotationSurrogatePositionNumber() {
        return this.quotationSurrogatePositionNumber;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public BigDecimal getProduct() {
        return this.product;
    }

    public String getRemark() {
        return this.remark;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getShortText() {
        return this.shortText;
    }

    public String getLongText() {
        return this.longText;
    }

    public BigDecimal getInternalSquadWagePerUnit() {
        return this.internalSquadWagePerUnit;
    }

    public BigDecimal getInternalSquadWageAggregated() {
        return this.internalSquadWageAggregated;
    }

    public void setPositionType(EPositionType positionType) {
        this.positionType = positionType;
    }

    public void setQuotationPositionNumber(String quotationPositionNumber) {
        this.quotationPositionNumber = quotationPositionNumber;
    }

    public void setQuotationSubPositionNumber(Integer quotationSubPositionNumber) {
        this.quotationSubPositionNumber = quotationSubPositionNumber;
    }

    public void setQuotationSurrogatePositionNumber(String quotationSurrogatePositionNumber) {
        this.quotationSurrogatePositionNumber = quotationSurrogatePositionNumber;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void setProduct(BigDecimal product) {
        this.product = product;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setShortText(String shortText) {
        this.shortText = shortText;
    }

    public void setLongText(String longText) {
        this.longText = longText;
    }

    public void setInternalSquadWagePerUnit(BigDecimal internalSquadWagePerUnit) {
        this.internalSquadWagePerUnit = internalSquadWagePerUnit;
    }

    public void setInternalSquadWageAggregated(BigDecimal internalSquadWageAggregated) {
        this.internalSquadWageAggregated = internalSquadWageAggregated;
    }
}

