/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.print.measurement;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.service.model.internal.pdfbox.EBooleanPrintOption;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementPrintConfiguration;
import java.awt.Color;
import java.time.LocalDate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;

public class MeasurementTransposedPrintConfiguration
extends MeasurementPrintConfiguration {
    public static final int DEFAULT__COLS_PER_ROTATED_PAGE = 9;
    public static final int DEFAULT__ROWS_PER_ROTATED_PAGE = 30;
    public static final int DEFAULT__MAX_HEADER_TEXT_LENGTH = 50;
    public static final Color DEFAULT_HEADER_BG_COLOR = Color.WHITE;
    public static final MeasurementTransposedPrintConfiguration DEFAULT = MeasurementTransposedPrintConfiguration.of((int)9, (int)30, (int)50);
    private final int maxColsPerPage;
    private final int maxRowsPerPage;
    private final int maxHeaderTextLength;

    private MeasurementTransposedPrintConfiguration(Color headerBgColor, int maxColsPerPage, int maxRowsPerPage, int maxHeaderTextLength, @NonNull Iterable<EBooleanPrintOption> booleanPrintOptions, @NonNull LocalDate printDate, @Nullable LocalDate transferOfPerilsDate) {
        super(headerBgColor, booleanPrintOptions, printDate, transferOfPerilsDate);
        if (booleanPrintOptions == null) {
            throw new NullPointerException("booleanPrintOptions is marked non-null but is null");
        }
        if (printDate == null) {
            throw new NullPointerException("printDate is marked non-null but is null");
        }
        this.maxColsPerPage = maxColsPerPage;
        this.maxRowsPerPage = maxRowsPerPage;
        this.maxHeaderTextLength = maxHeaderTextLength;
    }

    @Nonnull
    public static MeasurementTransposedPrintConfiguration of(@NonNull Iterable<EBooleanPrintOption> booleanPrintOptions) {
        if (booleanPrintOptions == null) {
            throw new NullPointerException("booleanPrintOptions is marked non-null but is null");
        }
        return new MeasurementTransposedPrintConfiguration(DEFAULT_HEADER_BG_COLOR, 9, 30, 50, (Iterable)ImmutableSet.copyOf(booleanPrintOptions), DateTimeHelper.today(), null);
    }

    @Nonnull
    public static MeasurementTransposedPrintConfiguration of(int maxColsPerPage, int maxRowsPerPage, int maxHeaderTextLength) {
        Preconditions.checkArgument((maxColsPerPage > 0 ? 1 : 0) != 0, (Object)"printConfiguration.maxColsPerPage() must be > 0");
        Preconditions.checkArgument((maxRowsPerPage > 0 ? 1 : 0) != 0, (Object)"printConfiguration.maxRowsPerPage() must be > 0");
        Preconditions.checkArgument((maxHeaderTextLength > 0 ? 1 : 0) != 0, (Object)"printConfiguration.maxHeaderTextLength() must be > 0");
        return new MeasurementTransposedPrintConfiguration(DEFAULT_HEADER_BG_COLOR, maxColsPerPage, maxRowsPerPage, maxHeaderTextLength, DEFAULT_BOOLEAN_PRINT_OPTIONS, DateTimeHelper.today(), null);
    }

    @Nonnull
    public static MeasurementTransposedPrintConfiguration of(@NonNull Color color, int maxColsPerPage, int maxRowsPerPage, int maxHeaderTextLength, @NonNull Iterable<EBooleanPrintOption> booleanPrintOptions, @NonNull LocalDate printDate, @Nullable LocalDate transferOfPerilsDate) {
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        if (booleanPrintOptions == null) {
            throw new NullPointerException("booleanPrintOptions is marked non-null but is null");
        }
        if (printDate == null) {
            throw new NullPointerException("printDate is marked non-null but is null");
        }
        Preconditions.checkArgument((maxColsPerPage > 0 ? 1 : 0) != 0, (Object)"printConfiguration.maxColsPerPage() must be > 0");
        Preconditions.checkArgument((maxRowsPerPage > 0 ? 1 : 0) != 0, (Object)"printConfiguration.maxRowsPerPage() must be > 0");
        Preconditions.checkArgument((maxHeaderTextLength > 0 ? 1 : 0) != 0, (Object)"printConfiguration.maxHeaderTextLength() must be > 0");
        return new MeasurementTransposedPrintConfiguration(color, maxColsPerPage, maxRowsPerPage, maxHeaderTextLength, (Iterable)ImmutableSet.copyOf(booleanPrintOptions), printDate, transferOfPerilsDate);
    }

    public int getMaxColsPerPage() {
        return this.maxColsPerPage;
    }

    public int getMaxRowsPerPage() {
        return this.maxRowsPerPage;
    }

    public int getMaxHeaderTextLength() {
        return this.maxHeaderTextLength;
    }

    public String toString() {
        return "MeasurementTransposedPrintConfiguration(super=" + super.toString() + ", maxColsPerPage=" + this.getMaxColsPerPage() + ", maxRowsPerPage=" + this.getMaxRowsPerPage() + ", maxHeaderTextLength=" + this.getMaxHeaderTextLength() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MeasurementTransposedPrintConfiguration)) {
            return false;
        }
        MeasurementTransposedPrintConfiguration other = (MeasurementTransposedPrintConfiguration)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getMaxColsPerPage() != other.getMaxColsPerPage()) {
            return false;
        }
        if (this.getMaxRowsPerPage() != other.getMaxRowsPerPage()) {
            return false;
        }
        return this.getMaxHeaderTextLength() == other.getMaxHeaderTextLength();
    }

    protected boolean canEqual(Object other) {
        return other instanceof MeasurementTransposedPrintConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getMaxColsPerPage();
        result = result * 59 + this.getMaxRowsPerPage();
        result = result * 59 + this.getMaxHeaderTextLength();
        return result;
    }
}

