/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.invoice;

import com.google.common.collect.ImmutableList;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceState;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import javax.annotation.Nonnull;
import lombok.NonNull;

public class InvoiceStateChangeBucket {
    private final EInvoiceState invoiceStateOld;
    private final EInvoiceState invoiceStateNew;
    private final Iterable<Invoice> finalInvoicesAccounted;

    public InvoiceStateChangeBucket(@NonNull EInvoiceState invoiceStateOld, @NonNull EInvoiceState invoiceStateNew, @NonNull Iterable<Invoice> finalInvoicesAccounted) {
        if (invoiceStateOld == null) {
            throw new NullPointerException("invoiceStateOld is marked non-null but is null");
        }
        if (invoiceStateNew == null) {
            throw new NullPointerException("invoiceStateNew is marked non-null but is null");
        }
        if (finalInvoicesAccounted == null) {
            throw new NullPointerException("finalInvoicesAccounted is marked non-null but is null");
        }
        this.invoiceStateOld = invoiceStateOld;
        this.invoiceStateNew = invoiceStateNew;
        this.finalInvoicesAccounted = finalInvoicesAccounted;
    }

    @Nonnull
    public static InvoiceStateChangeBucket of(@NonNull EInvoiceState invoiceStateOld, @NonNull EInvoiceState invoiceStateNew, @NonNull Iterable<Invoice> finalInvoices) {
        if (invoiceStateOld == null) {
            throw new NullPointerException("invoiceStateOld is marked non-null but is null");
        }
        if (invoiceStateNew == null) {
            throw new NullPointerException("invoiceStateNew is marked non-null but is null");
        }
        if (finalInvoices == null) {
            throw new NullPointerException("finalInvoices is marked non-null but is null");
        }
        return new InvoiceStateChangeBucket(invoiceStateOld, invoiceStateNew, (Iterable)ImmutableList.copyOf(finalInvoices));
    }

    public EInvoiceState getInvoiceStateOld() {
        return this.invoiceStateOld;
    }

    public EInvoiceState getInvoiceStateNew() {
        return this.invoiceStateNew;
    }

    public Iterable<Invoice> getFinalInvoicesAccounted() {
        return this.finalInvoicesAccounted;
    }
}

