/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.invoice;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import de.qfm.erp.service.model.internal.invoice.EImportResultType;
import de.qfm.erp.service.model.internal.invoice.EPdfExtractType;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.web.multipart.MultipartFile;

public class CreditVoucherImportResult {
    @NonNull
    private final EImportResultType importResultType;
    @NonNull
    private final MultipartFile multipartFile;
    @NonNull
    private final Invoice invoice;
    @NonNull
    private final Iterable<String> errors;
    @NonNull
    private final EPdfExtractType pdfExtractType;
    private static final Invoice NO_INVOICE = new Invoice();

    private CreditVoucherImportResult(@NonNull EImportResultType importResultType, @NonNull MultipartFile multipartFile, @NonNull Invoice invoice, @NonNull Iterable<String> errors, @NonNull EPdfExtractType pdfExtractType) {
        if (importResultType == null) {
            throw new NullPointerException("importResultType is marked non-null but is null");
        }
        if (multipartFile == null) {
            throw new NullPointerException("multipartFile is marked non-null but is null");
        }
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        if (errors == null) {
            throw new NullPointerException("errors is marked non-null but is null");
        }
        if (pdfExtractType == null) {
            throw new NullPointerException("pdfExtractType is marked non-null but is null");
        }
        this.importResultType = importResultType;
        this.multipartFile = multipartFile;
        this.invoice = invoice;
        this.errors = errors;
        this.pdfExtractType = pdfExtractType;
    }

    @Nonnull
    public static CreditVoucherImportResult success(@NonNull MultipartFile multipartFile, @NonNull Invoice invoice, @NonNull Iterable<String> errors, @NonNull EPdfExtractType pdfExtractType) {
        if (multipartFile == null) {
            throw new NullPointerException("multipartFile is marked non-null but is null");
        }
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        if (errors == null) {
            throw new NullPointerException("errors is marked non-null but is null");
        }
        if (pdfExtractType == null) {
            throw new NullPointerException("pdfExtractType is marked non-null but is null");
        }
        EImportResultType importResultType = Iterables.isEmpty(errors) ? EImportResultType.INFO : EImportResultType.WARN;
        return new CreditVoucherImportResult(importResultType, multipartFile, invoice, (Iterable)ImmutableList.copyOf(errors), pdfExtractType);
    }

    @Nonnull
    public static CreditVoucherImportResult error(@NonNull MultipartFile multipartFile, @NonNull Iterable<String> errors, @NonNull EPdfExtractType pdfExtractType) {
        if (multipartFile == null) {
            throw new NullPointerException("multipartFile is marked non-null but is null");
        }
        if (errors == null) {
            throw new NullPointerException("errors is marked non-null but is null");
        }
        if (pdfExtractType == null) {
            throw new NullPointerException("pdfExtractType is marked non-null but is null");
        }
        return new CreditVoucherImportResult(EImportResultType.ERROR, multipartFile, NO_INVOICE, (Iterable)ImmutableList.copyOf(errors), pdfExtractType);
    }

    @NonNull
    public EImportResultType getImportResultType() {
        return this.importResultType;
    }

    @NonNull
    public MultipartFile getMultipartFile() {
        return this.multipartFile;
    }

    @NonNull
    public Invoice getInvoice() {
        return this.invoice;
    }

    @NonNull
    public Iterable<String> getErrors() {
        return this.errors;
    }

    @NonNull
    public EPdfExtractType getPdfExtractType() {
        return this.pdfExtractType;
    }
}

