/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal.costcenter;

import com.google.common.base.CharMatcher;
import de.qfm.erp.service.model.internal.costcenter.ECostCenterFilterType;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CostCenterFilter {
    @Nonnull
    public static final CostCenterFilter EMPTY = CostCenterFilter.of((ECostCenterFilterType)ECostCenterFilterType.ALL, (String)"");
    @NonNull
    private final ECostCenterFilterType costCenterFilterType;
    @NonNull
    private final String costCenter;
    private static final String ALLOWED_SUFFIX = "*";
    private static final CharMatcher VALID_CC_CHARS = CharMatcher.inRange((char)'0', (char)'9').or(CharMatcher.inRange((char)'a', (char)'z')).or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.anyOf((CharSequence)"-"));

    @Nonnull
    public static CostCenterFilter from(@NonNull String costCenterFilterCandidate) {
        if (costCenterFilterCandidate == null) {
            throw new NullPointerException("costCenterFilterCandidate is marked non-null but is null");
        }
        boolean hasSuffix = StringUtils.endsWith((CharSequence)costCenterFilterCandidate, (CharSequence)"*");
        String costCenter = VALID_CC_CHARS.retainFrom((CharSequence)StringUtils.trimToEmpty((String)costCenterFilterCandidate));
        if (StringUtils.isNotBlank((CharSequence)costCenter)) {
            if (hasSuffix) {
                return CostCenterFilter.of((ECostCenterFilterType)ECostCenterFilterType.STARTS_WITH, (String)costCenter);
            }
            return CostCenterFilter.of((ECostCenterFilterType)ECostCenterFilterType.EQ, (String)costCenter);
        }
        return EMPTY;
    }

    @Nonnull
    public static CostCenterFilter children(@NonNull String costCenterFilterCandidate) {
        if (costCenterFilterCandidate == null) {
            throw new NullPointerException("costCenterFilterCandidate is marked non-null but is null");
        }
        String costCenterWithoutZero = StringUtils.stripEnd((String)costCenterFilterCandidate, (String)"0");
        return CostCenterFilter.of((ECostCenterFilterType)ECostCenterFilterType.STARTS_WITH, (String)costCenterWithoutZero);
    }

    @Nonnull
    public String asFileName() {
        return StringUtils.replace((String)this.costCenter, (String)"*", (String)"x");
    }

    private CostCenterFilter(@NonNull ECostCenterFilterType costCenterFilterType, @NonNull String costCenter) {
        if (costCenterFilterType == null) {
            throw new NullPointerException("costCenterFilterType is marked non-null but is null");
        }
        if (costCenter == null) {
            throw new NullPointerException("costCenter is marked non-null but is null");
        }
        this.costCenterFilterType = costCenterFilterType;
        this.costCenter = costCenter;
    }

    public static CostCenterFilter of(@NonNull ECostCenterFilterType costCenterFilterType, @NonNull String costCenter) {
        if (costCenterFilterType == null) {
            throw new NullPointerException("costCenterFilterType is marked non-null but is null");
        }
        if (costCenter == null) {
            throw new NullPointerException("costCenter is marked non-null but is null");
        }
        return new CostCenterFilter(costCenterFilterType, costCenter);
    }

    @NonNull
    public ECostCenterFilterType getCostCenterFilterType() {
        return this.costCenterFilterType;
    }

    @NonNull
    public String getCostCenter() {
        return this.costCenter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CostCenterFilter)) {
            return false;
        }
        CostCenterFilter other = (CostCenterFilter)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ECostCenterFilterType this$costCenterFilterType = this.getCostCenterFilterType();
        ECostCenterFilterType other$costCenterFilterType = other.getCostCenterFilterType();
        if (this$costCenterFilterType == null ? other$costCenterFilterType != null : !this$costCenterFilterType.equals(other$costCenterFilterType)) {
            return false;
        }
        String this$costCenter = this.getCostCenter();
        String other$costCenter = other.getCostCenter();
        return !(this$costCenter == null ? other$costCenter != null : !this$costCenter.equals(other$costCenter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CostCenterFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ECostCenterFilterType $costCenterFilterType = this.getCostCenterFilterType();
        result = result * 59 + ($costCenterFilterType == null ? 43 : $costCenterFilterType.hashCode());
        String $costCenter = this.getCostCenter();
        result = result * 59 + ($costCenter == null ? 43 : $costCenter.hashCode());
        return result;
    }

    public String toString() {
        return "CostCenterFilter(costCenterFilterType=" + String.valueOf(this.getCostCenterFilterType()) + ", costCenter=" + this.getCostCenter() + ")";
    }
}

