/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal;

import com.google.common.collect.ImmutableList;
import de.qfm.erp.common.request.UpdateRequest;
import de.qfm.erp.common.request.user.UserUpdateRequest;
import de.qfm.erp.service.model.internal.UpdateBucket;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.employee.payroll.WageAccount;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.model.jpa.user.Role;
import de.qfm.erp.service.model.jpa.user.User;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;

public class UserUpdateBucket
extends UpdateBucket<UserUpdateRequest, User> {
    private final boolean changePassword;
    @NonNull
    private final String encryptedPassword;
    @Nullable
    private final User squadLeader;
    @Nullable
    private final Role role;
    @NonNull
    private final WageAccount wageAccount;
    @NonNull
    private final Iterable<Role> userRoles;
    @NonNull
    private final Iterable<EPrivilege> userPrivileges;

    private UserUpdateBucket(@NonNull UserUpdateRequest updateRequest, @NonNull User entity, @Nullable User existing, boolean changePassword, @NonNull String encryptedPassword, @Nullable User squadLeader, @Nullable Role role, @NonNull WageAccount wageAccount, @NonNull Iterable<Role> userRoles, @NonNull Iterable<EPrivilege> userPrivileges) {
        super((UpdateRequest)updateRequest, (EntityBase)entity, (EntityBase)existing);
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (encryptedPassword == null) {
            throw new NullPointerException("encryptedPassword is marked non-null but is null");
        }
        if (wageAccount == null) {
            throw new NullPointerException("wageAccount is marked non-null but is null");
        }
        if (userRoles == null) {
            throw new NullPointerException("userRoles is marked non-null but is null");
        }
        if (userPrivileges == null) {
            throw new NullPointerException("userPrivileges is marked non-null but is null");
        }
        this.changePassword = changePassword;
        this.encryptedPassword = encryptedPassword;
        this.squadLeader = squadLeader;
        this.role = role;
        this.wageAccount = wageAccount;
        this.userRoles = userRoles;
        this.userPrivileges = userPrivileges;
    }

    @Nonnull
    public static UserUpdateBucket of(@NonNull UserUpdateRequest updateRequest, @NonNull User entity, @Nullable User existing, boolean changePassword, @NonNull String encryptedPassword, @Nullable User squadLeader, @Nullable Role role, @NonNull WageAccount wageAccount, @NonNull Iterable<Role> userRoles, @NonNull Iterable<EPrivilege> userPrivileges) {
        if (updateRequest == null) {
            throw new NullPointerException("updateRequest is marked non-null but is null");
        }
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (encryptedPassword == null) {
            throw new NullPointerException("encryptedPassword is marked non-null but is null");
        }
        if (wageAccount == null) {
            throw new NullPointerException("wageAccount is marked non-null but is null");
        }
        if (userRoles == null) {
            throw new NullPointerException("userRoles is marked non-null but is null");
        }
        if (userPrivileges == null) {
            throw new NullPointerException("userPrivileges is marked non-null but is null");
        }
        return new UserUpdateBucket(updateRequest, entity, existing, changePassword, encryptedPassword, squadLeader, role, wageAccount, (Iterable)ImmutableList.copyOf(userRoles), (Iterable)ImmutableList.copyOf(userPrivileges));
    }

    public boolean isChangePassword() {
        return this.changePassword;
    }

    @NonNull
    public String getEncryptedPassword() {
        return this.encryptedPassword;
    }

    @Nullable
    public User getSquadLeader() {
        return this.squadLeader;
    }

    @Nullable
    public Role getRole() {
        return this.role;
    }

    @NonNull
    public WageAccount getWageAccount() {
        return this.wageAccount;
    }

    @NonNull
    public Iterable<Role> getUserRoles() {
        return this.userRoles;
    }

    @NonNull
    public Iterable<EPrivilege> getUserPrivileges() {
        return this.userPrivileges;
    }
}

