/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.model.internal;

import de.qfm.erp.service.model.internal.EStringSearchFilterType;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class StringSearchFilter {
    @Nonnull
    public static final StringSearchFilter EMPTY = StringSearchFilter.of((EStringSearchFilterType)EStringSearchFilterType.ALL, (String)"");
    @NonNull
    private final EStringSearchFilterType stringSearchFilterType;
    @NonNull
    private final String value;
    private static final String ALLOWED_SUFFIX_PREFIX = "*";

    @Nonnull
    public static StringSearchFilter from(@NonNull String stringSearchFilterCandidate) {
        if (stringSearchFilterCandidate == null) {
            throw new NullPointerException("stringSearchFilterCandidate is marked non-null but is null");
        }
        boolean endsWithStar = StringUtils.endsWith((CharSequence)stringSearchFilterCandidate, (CharSequence)"*");
        boolean beginsWithStar = StringUtils.startsWith((CharSequence)stringSearchFilterCandidate, (CharSequence)"*");
        String value = StringUtils.removeStart((String)StringUtils.removeEnd((String)StringUtils.trimToEmpty((String)stringSearchFilterCandidate), (String)"*"), (String)"*");
        if (StringUtils.isNotBlank((CharSequence)value)) {
            if (endsWithStar && beginsWithStar) {
                return StringSearchFilter.of((EStringSearchFilterType)EStringSearchFilterType.CONTAINS, (String)value);
            }
            if (endsWithStar && !beginsWithStar) {
                return StringSearchFilter.of((EStringSearchFilterType)EStringSearchFilterType.STARTS_WITH, (String)value);
            }
            if (!endsWithStar && beginsWithStar) {
                return StringSearchFilter.of((EStringSearchFilterType)EStringSearchFilterType.ENDS_WITH, (String)value);
            }
            return StringSearchFilter.of((EStringSearchFilterType)EStringSearchFilterType.EQ, (String)value);
        }
        return EMPTY;
    }

    private StringSearchFilter(@NonNull EStringSearchFilterType stringSearchFilterType, @NonNull String value) {
        if (stringSearchFilterType == null) {
            throw new NullPointerException("stringSearchFilterType is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.stringSearchFilterType = stringSearchFilterType;
        this.value = value;
    }

    public static StringSearchFilter of(@NonNull EStringSearchFilterType stringSearchFilterType, @NonNull String value) {
        if (stringSearchFilterType == null) {
            throw new NullPointerException("stringSearchFilterType is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new StringSearchFilter(stringSearchFilterType, value);
    }

    @NonNull
    public EStringSearchFilterType getStringSearchFilterType() {
        return this.stringSearchFilterType;
    }

    @NonNull
    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringSearchFilter)) {
            return false;
        }
        StringSearchFilter other = (StringSearchFilter)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        EStringSearchFilterType this$stringSearchFilterType = this.getStringSearchFilterType();
        EStringSearchFilterType other$stringSearchFilterType = other.getStringSearchFilterType();
        if (this$stringSearchFilterType == null ? other$stringSearchFilterType != null : !this$stringSearchFilterType.equals(other$stringSearchFilterType)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StringSearchFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EStringSearchFilterType $stringSearchFilterType = this.getStringSearchFilterType();
        result = result * 59 + ($stringSearchFilterType == null ? 43 : $stringSearchFilterType.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "StringSearchFilter(stringSearchFilterType=" + String.valueOf(this.getStringSearchFilterType()) + ", value=" + this.getValue() + ")";
    }
}

