/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.helper.comparator.quotation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import de.qfm.erp.service.helper.comparator.quotation.QuotationPositionComparator;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import de.qfm.erp.service.model.jpa.shared.EPositionType;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class QuotationPositionGroupingLevelComparator
extends QuotationPositionComparator {
    private static final Logger log = LogManager.getLogger(QuotationPositionGroupingLevelComparator.class);
    private final boolean considerPositionNumber;
    static final Iterable<String> X = ImmutableSet.of((Object)"*", (Object)"#");

    public int compare(@NonNull QuotationPosition left, @NonNull QuotationPosition right) {
        Quotation rightQuotation;
        long addendumNumberRight;
        if (left == null) {
            throw new NullPointerException("left is marked non-null but is null");
        }
        if (right == null) {
            throw new NullPointerException("right is marked non-null but is null");
        }
        Quotation leftQuotation = left.getQuotation();
        long addendumNumberLeft = null != leftQuotation ? (Long)MoreObjects.firstNonNull((Object)leftQuotation.getAddendumNumber(), (Object)0L) : 0L;
        int i = Longs.compare((long)addendumNumberLeft, (long)(addendumNumberRight = null != (rightQuotation = right.getQuotation()) ? (Long)MoreObjects.firstNonNull((Object)rightQuotation.getAddendumNumber(), (Object)0L) : 0L));
        if (i != 0) {
            return i;
        }
        i = QuotationPositionGroupingLevelComparator.strCmp((String)left.getGroupingElementLevel1(), (String)right.getGroupingElementLevel1());
        if (i != 0) {
            return i;
        }
        i = QuotationPositionGroupingLevelComparator.strCmp((String)left.getGroupingElementLevel2(), (String)right.getGroupingElementLevel2());
        if (i != 0) {
            return i;
        }
        i = QuotationPositionGroupingLevelComparator.strCmp((String)left.getGroupingElementLevel3(), (String)right.getGroupingElementLevel3());
        if (i != 0) {
            return i;
        }
        i = QuotationPositionGroupingLevelComparator.strCmp((String)left.getGroupingElementLevel4(), (String)right.getGroupingElementLevel4());
        if (i != 0) {
            return i;
        }
        EPositionType leftPositionType = left.getPositionType();
        EPositionType rightPositionType = right.getPositionType();
        if ((EPositionType.STANDARD == leftPositionType || EPositionType.CHANGE_IN_QUANTITY == leftPositionType) && EPositionType.COMMENT == rightPositionType) {
            return 1;
        }
        if (EPositionType.COMMENT == leftPositionType && (EPositionType.STANDARD == rightPositionType || EPositionType.CHANGE_IN_QUANTITY == rightPositionType)) {
            return -1;
        }
        if (this.considerPositionNumber && (i = QuotationPositionGroupingLevelComparator.strCmp((String)left.getPositionNumber(), (String)right.getPositionNumber())) != 0) {
            return i;
        }
        Integer leftSequenceNumber = (Integer)MoreObjects.firstNonNull((Object)left.getSequenceNumberQuotationStandard(), (Object)0);
        Integer rightSequenceNumber = (Integer)MoreObjects.firstNonNull((Object)right.getSequenceNumberQuotationStandard(), (Object)0);
        return Ints.compare((int)leftSequenceNumber, (int)rightSequenceNumber);
    }

    @VisibleForTesting
    public static int strCmp(@Nullable String leftCandidate, @Nullable String rightCandidate) {
        String leftX = StringUtils.trimToNull((String)leftCandidate);
        String rightX = StringUtils.trimToNull((String)rightCandidate);
        String left = Iterables.contains((Iterable)X, (Object)leftX) ? null : leftX;
        String right = Iterables.contains((Iterable)X, (Object)rightX) ? null : rightX;
        return StringUtils.compare((String)left, (String)right, (boolean)true);
    }

    public QuotationPositionComparator from(@NonNull Quotation quotation) {
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        return this;
    }

    private QuotationPositionGroupingLevelComparator(boolean considerPositionNumber) {
        this.considerPositionNumber = considerPositionNumber;
    }

    public static QuotationPositionGroupingLevelComparator of(boolean considerPositionNumber) {
        return new QuotationPositionGroupingLevelComparator(considerPositionNumber);
    }
}

