/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.helper;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.qfm.erp.service.helper.BigDecimalHelper;
import de.qfm.erp.service.helper.comparator.measurement.MeasurementPositionGroupingLevelComparator;
import de.qfm.erp.service.model.internal.measurement.IMeasurementListingItem;
import de.qfm.erp.service.model.internal.measurement.MeasurementDashboard;
import de.qfm.erp.service.model.internal.measurement.MeasurementExport;
import de.qfm.erp.service.model.internal.measurement.MeasurementPositionGroup;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import de.qfm.erp.service.model.jpa.shared.EPositionType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class MeasurementHelper {
    public static final Function<MeasurementPosition, BigDecimal> FN_JUMBO_PROD = item -> {
        EPositionType positionType = item.getPositionType();
        if (EPositionType.JUMBO_INTERNAL_TYPE_A == positionType) {
            return item.getPriceAggregated();
        }
        return item.getProduct();
    };

    @Nonnull
    public static BigDecimal wageFactor(@NonNull MeasurementDashboard measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        BigDecimal companyWage = (BigDecimal)MoreObjects.firstNonNull((Object)measurement.getCompanyWageOverall(), (Object)BigDecimal.ZERO);
        BigDecimal squadWage = (BigDecimal)MoreObjects.firstNonNull((Object)measurement.getSquadWageOverall(), (Object)BigDecimal.ZERO);
        return MeasurementHelper.wageFactor((BigDecimal)companyWage, (BigDecimal)squadWage);
    }

    @Nonnull
    public static BigDecimal wageFactor(@NonNull IMeasurementListingItem measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        BigDecimal companyWage = (BigDecimal)MoreObjects.firstNonNull((Object)measurement.getCompanyWageOverall(), (Object)BigDecimal.ZERO);
        BigDecimal squadWage = (BigDecimal)MoreObjects.firstNonNull((Object)measurement.getSquadWageOverall(), (Object)BigDecimal.ZERO);
        return MeasurementHelper.wageFactor((BigDecimal)companyWage, (BigDecimal)squadWage);
    }

    @Nonnull
    public static BigDecimal wageFactor(@NonNull Measurement measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        BigDecimal companyWage = (BigDecimal)MoreObjects.firstNonNull((Object)measurement.getCompanyWageOverall(), (Object)BigDecimal.ZERO);
        BigDecimal squadWage = (BigDecimal)MoreObjects.firstNonNull((Object)measurement.getSquadWageOverall(), (Object)BigDecimal.ZERO);
        return MeasurementHelper.wageFactor((BigDecimal)companyWage, (BigDecimal)squadWage);
    }

    @Nonnull
    public static BigDecimal wagePercentage(@NonNull IMeasurementListingItem measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        BigDecimal wageFactor = MeasurementHelper.wageFactor((IMeasurementListingItem)measurement);
        return wageFactor.multiply(BigDecimal.valueOf(100L));
    }

    @Nonnull
    public static BigDecimal wagePercentage(@NonNull Measurement measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        BigDecimal wageFactor = MeasurementHelper.wageFactor((Measurement)measurement);
        return wageFactor.multiply(BigDecimal.valueOf(100L));
    }

    @Nonnull
    public static BigDecimal wageFactor(@NonNull MeasurementExport measurementExport) {
        if (measurementExport == null) {
            throw new NullPointerException("measurementExport is marked non-null but is null");
        }
        BigDecimal companyWage = (BigDecimal)MoreObjects.firstNonNull((Object)measurementExport.getCompanyWageOverall(), (Object)BigDecimal.ZERO);
        BigDecimal squadWage = (BigDecimal)MoreObjects.firstNonNull((Object)measurementExport.getSquadWageOverall(), (Object)BigDecimal.ZERO);
        return MeasurementHelper.wageFactor((BigDecimal)companyWage, (BigDecimal)squadWage);
    }

    @Nonnull
    public static BigDecimal wageFactor(@NonNull BigDecimal companyWage, @NonNull BigDecimal squadWage) {
        if (companyWage == null) {
            throw new NullPointerException("companyWage is marked non-null but is null");
        }
        if (squadWage == null) {
            throw new NullPointerException("squadWage is marked non-null but is null");
        }
        if (BigDecimalHelper.anyZero((BigDecimal[])new BigDecimal[]{companyWage, squadWage})) {
            return BigDecimal.ZERO;
        }
        return companyWage.divide(squadWage, 2, RoundingMode.HALF_UP);
    }

    @Nonnull
    public static BigDecimal notAccountedPurchasePrice(@NonNull MeasurementDashboard measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        BigDecimal first = (BigDecimal)MoreObjects.firstNonNull((Object)measurement.getCompanyWageOverall(), (Object)BigDecimal.ZERO);
        BigDecimal second = (BigDecimal)MoreObjects.firstNonNull((Object)measurement.getMaterialPurchasePriceOverall(), (Object)BigDecimal.ZERO);
        BigDecimal third = (BigDecimal)MoreObjects.firstNonNull((Object)measurement.getExternalServicePurchasePriceOverall(), (Object)BigDecimal.ZERO);
        return first.add(second).add(third);
    }

    @Nonnull
    public static BigDecimal notAccountedPurchasePrice(@NonNull IMeasurementListingItem measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        BigDecimal first = (BigDecimal)MoreObjects.firstNonNull((Object)measurement.getCompanyWageOverall(), (Object)BigDecimal.ZERO);
        BigDecimal second = (BigDecimal)MoreObjects.firstNonNull((Object)measurement.getMaterialPurchasePriceOverall(), (Object)BigDecimal.ZERO);
        BigDecimal third = (BigDecimal)MoreObjects.firstNonNull((Object)measurement.getExternalServicePurchasePriceOverall(), (Object)BigDecimal.ZERO);
        return first.add(second).add(third);
    }

    @Nonnull
    public static BigDecimal notAccountedPurchasePrice(@NonNull Measurement measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        BigDecimal first = (BigDecimal)MoreObjects.firstNonNull((Object)measurement.getCompanyWageOverall(), (Object)BigDecimal.ZERO);
        BigDecimal second = (BigDecimal)MoreObjects.firstNonNull((Object)measurement.getMaterialPurchasePriceOverall(), (Object)BigDecimal.ZERO);
        BigDecimal third = (BigDecimal)MoreObjects.firstNonNull((Object)measurement.getExternalServicePurchasePriceOverall(), (Object)BigDecimal.ZERO);
        return first.add(second).add(third);
    }

    @Nonnull
    public static BigDecimal notAccountedPurchasePrice(@NonNull MeasurementExport measurementExport) {
        if (measurementExport == null) {
            throw new NullPointerException("measurementExport is marked non-null but is null");
        }
        BigDecimal first = (BigDecimal)MoreObjects.firstNonNull((Object)measurementExport.getCompanyWageOverall(), (Object)BigDecimal.ZERO);
        BigDecimal second = (BigDecimal)MoreObjects.firstNonNull((Object)measurementExport.getMaterialPurchasePriceOverall(), (Object)BigDecimal.ZERO);
        BigDecimal third = (BigDecimal)MoreObjects.firstNonNull((Object)measurementExport.getExternalServicePurchasePriceOverall(), (Object)BigDecimal.ZERO);
        return first.add(second).add(third);
    }

    @Nonnull
    public static BigDecimal notAccountedSellingPrice(@NonNull MeasurementDashboard measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        BigDecimal first = (BigDecimal)MoreObjects.firstNonNull((Object)measurement.getCompanyWageOverall(), (Object)BigDecimal.ZERO);
        BigDecimal second = (BigDecimal)MoreObjects.firstNonNull((Object)measurement.getMaterialSellingPriceOverall(), (Object)BigDecimal.ZERO);
        BigDecimal third = (BigDecimal)MoreObjects.firstNonNull((Object)measurement.getExternalServiceSellingPriceOverall(), (Object)BigDecimal.ZERO);
        return first.add(second).add(third);
    }

    @Nonnull
    public static BigDecimal notAccountedSellingPrice(@NonNull IMeasurementListingItem measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        BigDecimal first = (BigDecimal)MoreObjects.firstNonNull((Object)measurement.getCompanyWageOverall(), (Object)BigDecimal.ZERO);
        BigDecimal second = (BigDecimal)MoreObjects.firstNonNull((Object)measurement.getMaterialSellingPriceOverall(), (Object)BigDecimal.ZERO);
        BigDecimal third = (BigDecimal)MoreObjects.firstNonNull((Object)measurement.getExternalServiceSellingPriceOverall(), (Object)BigDecimal.ZERO);
        return first.add(second).add(third);
    }

    @Nonnull
    public static BigDecimal notAccountedSellingPrice(@NonNull Measurement measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        BigDecimal first = (BigDecimal)MoreObjects.firstNonNull((Object)measurement.getCompanyWageOverall(), (Object)BigDecimal.ZERO);
        BigDecimal second = (BigDecimal)MoreObjects.firstNonNull((Object)measurement.getMaterialSellingPriceOverall(), (Object)BigDecimal.ZERO);
        BigDecimal third = (BigDecimal)MoreObjects.firstNonNull((Object)measurement.getExternalServiceSellingPriceOverall(), (Object)BigDecimal.ZERO);
        return first.add(second).add(third);
    }

    @Nonnull
    public static BigDecimal notAccountedSellingPrice(@NonNull MeasurementExport measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        BigDecimal first = (BigDecimal)MoreObjects.firstNonNull((Object)measurement.getCompanyWageOverall(), (Object)BigDecimal.ZERO);
        BigDecimal second = (BigDecimal)MoreObjects.firstNonNull((Object)measurement.getMaterialSellingPriceOverall(), (Object)BigDecimal.ZERO);
        BigDecimal third = (BigDecimal)MoreObjects.firstNonNull((Object)measurement.getExternalServiceSellingPriceOverall(), (Object)BigDecimal.ZERO);
        return first.add(second).add(third);
    }

    @Nonnull
    @VisibleForTesting
    public static Set<String> missingSurrogatePositionNumbers(@NonNull Measurement measurement, @NonNull Map<String, QuotationPosition> quotationPositionsBySurrogatePositionNumber) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        if (quotationPositionsBySurrogatePositionNumber == null) {
            throw new NullPointerException("quotationPositionsBySurrogatePositionNumber is marked non-null but is null");
        }
        ImmutableSet.Builder notFoundBuilder = ImmutableSet.builder();
        List measurementPositions = (List)MoreObjects.firstNonNull((Object)measurement.getMeasurementPositions(), (Object)ImmutableList.of());
        for (MeasurementPosition measurementPosition : measurementPositions) {
            String shortTextNeeded = StringUtils.trimToEmpty((String)measurementPosition.getShortText());
            String surrogatePositionNumberNeeded = measurementPosition.getSurrogatePositionNumber();
            if (quotationPositionsBySurrogatePositionNumber.containsKey(surrogatePositionNumberNeeded)) {
                QuotationPosition quotationPosition = quotationPositionsBySurrogatePositionNumber.get(surrogatePositionNumberNeeded);
                String shortTextAvailable = StringUtils.trimToEmpty((String)quotationPosition.getShortText());
                if (StringUtils.equalsIgnoreCase((CharSequence)shortTextAvailable, (CharSequence)shortTextNeeded)) continue;
                notFoundBuilder.add((Object)surrogatePositionNumberNeeded);
                continue;
            }
            notFoundBuilder.add((Object)surrogatePositionNumberNeeded);
        }
        return notFoundBuilder.build();
    }

    @Nonnull
    public static Long addendumNumber(@Nullable MeasurementPosition measurementPosition, boolean optionIgnoreAddendum) {
        Quotation stage;
        if (optionIgnoreAddendum) {
            return 0L;
        }
        Quotation quotation = stage = null != measurementPosition ? measurementPosition.getQuotation() : null;
        return null != stage ? (Long)MoreObjects.firstNonNull((Object)stage.getAddendumNumber(), (Object)0L) : (null != measurementPosition ? (Long)MoreObjects.firstNonNull((Object)measurementPosition.getAddendumNumber(), (Object)0L) : Long.valueOf(0L));
    }

    @Nonnull
    public static Iterable<MeasurementPositionGroup> positionGroups(@NonNull Measurement measurement, boolean flatten) {
        String key;
        String parentKey;
        MeasurementPositionGroup positionGroup;
        Object positionType;
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        LinkedHashMap positionInGroups = Maps.newLinkedHashMap();
        List positions = (List)MoreObjects.firstNonNull((Object)measurement.getMeasurementPositions(), (Object)ImmutableList.of());
        ImmutableList positionsSorted = ImmutableList.sortedCopyOf((Comparator)MeasurementPositionGroupingLevelComparator.of((boolean)true), (Iterable)positions);
        Long maxId = positions.stream().map(MeasurementPosition::getId).max(Long::compareTo).orElse(0L);
        AtomicLong fallbackId = new AtomicLong(1L + maxId);
        for (MeasurementPosition measurementPosition : positionsSorted) {
            positionType = measurementPosition.getPositionType();
            if (!Iterables.contains((Iterable)EPositionType.PRINTABLE_POSITIONS, (Object)positionType)) continue;
            String parentKey2 = MeasurementHelper.groupKey((MeasurementPosition)measurementPosition);
            do {
                if (positionInGroups.containsKey(parentKey2)) continue;
                positionGroup = MeasurementPositionGroup.generated();
                positionGroup.setId(Long.valueOf(fallbackId.getAndIncrement()));
                positionGroup.setKey(parentKey2);
                positionGroup.setShortText(StringUtils.trimToEmpty((String)measurementPosition.getShortText()));
                positionGroup.setLongText(StringUtils.trimToEmpty((String)measurementPosition.getLongText()));
                positionInGroups.put(parentKey2, positionGroup);
            } while (StringUtils.isNotBlank((CharSequence)(parentKey2 = MeasurementHelper.parentKey((String)parentKey2))));
        }
        for (Map.Entry entry : positionInGroups.entrySet()) {
            String key2 = (String)entry.getKey();
            MeasurementPositionGroup value = (MeasurementPositionGroup)entry.getValue();
            parentKey = MeasurementHelper.parentKey((String)key2);
            MeasurementPositionGroup parent = (MeasurementPositionGroup)positionInGroups.get(parentKey);
            if (null == parent || value == parent) continue;
            parent.getChildren().put(key2, value);
        }
        for (MeasurementPosition measurementPosition : positionsSorted) {
            positionType = measurementPosition.getPositionType();
            key = MeasurementHelper.groupKey((MeasurementPosition)measurementPosition);
            parentKey = MeasurementHelper.parentKey((MeasurementPosition)measurementPosition);
            boolean root = positionType == EPositionType.COMMENT && StringUtils.isBlank((CharSequence)parentKey);
            if (root || positionType != EPositionType.COMMENT || StringUtils.equals((CharSequence)key, (CharSequence)parentKey)) continue;
            MeasurementPositionGroup current = (MeasurementPositionGroup)positionInGroups.get(key);
            if (positionInGroups.containsKey(parentKey)) {
                MeasurementPositionGroup parent = (MeasurementPositionGroup)positionInGroups.get(parentKey);
                Map children = parent.getChildren();
                children.put(current.getKey(), current);
                continue;
            }
            throw new IllegalArgumentException("Should never Happen:" + parentKey);
        }
        for (MeasurementPosition measurementPosition : positionsSorted) {
            positionType = measurementPosition.getPositionType();
            if (positionType == EPositionType.COMMENT) {
                key = MeasurementHelper.groupKey((MeasurementPosition)measurementPosition);
                if (positionInGroups.containsKey(key)) {
                    positionGroup = (MeasurementPositionGroup)positionInGroups.get(key);
                    positionGroup.getComments().add(measurementPosition);
                    continue;
                }
                positionGroup = MeasurementPositionGroup.generated();
                positionGroup.setId(measurementPosition.getId());
                positionGroup.setKey(key);
                positionGroup.setShortText(StringUtils.trimToEmpty((String)measurementPosition.getShortText()));
                positionGroup.setLongText(StringUtils.trimToEmpty((String)measurementPosition.getLongText()));
                positionInGroups.put(key, positionGroup);
                continue;
            }
            if (!Iterables.contains((Iterable)EPositionType.PRINTABLE_POSITIONS, (Object)positionType)) continue;
            key = MeasurementHelper.standardKeys((MeasurementPosition)measurementPosition);
            if (positionInGroups.containsKey(key)) {
                positionGroup = (MeasurementPositionGroup)positionInGroups.get(key);
                positionGroup.getPositions().add(measurementPosition);
                continue;
            }
            throw new IllegalArgumentException("Should never Happen as we defined already all possible Groups for key: " + key);
        }
        TreeSet allKeys = Sets.newTreeSet(positionInGroups.keySet());
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet();
        for (String s : allKeys) {
            positionGroup = (MeasurementPositionGroup)positionInGroups.get(s);
            Map children = (Map)MoreObjects.firstNonNull((Object)positionGroup.getChildren(), (Object)ImmutableMap.of());
            linkedHashSet.addAll(children.keySet());
        }
        ImmutableList.Builder positionGroupsSorted = ImmutableList.builder();
        for (String currentKey : allKeys) {
            if (!flatten && linkedHashSet.contains(currentKey)) continue;
            positionGroupsSorted.add((Object)((MeasurementPositionGroup)positionInGroups.get(currentKey)));
        }
        return positionGroupsSorted.build();
    }

    @Nonnull
    @VisibleForTesting
    static String groupKey(@NonNull MeasurementPosition position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        String g1 = position.getGroupingElementLevel1();
        String g2 = position.getGroupingElementLevel2();
        String g3 = position.getGroupingElementLevel3();
        String g4 = position.getGroupingElementLevel4();
        ArrayList currentKey = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)g4) && !StringUtils.equals((CharSequence)g4, (CharSequence)"*")) {
            currentKey.add(g1);
            currentKey.add(g2);
            currentKey.add(g3);
            currentKey.add(g4);
        } else if (StringUtils.isNotBlank((CharSequence)g3) && !StringUtils.equals((CharSequence)g3, (CharSequence)"*")) {
            currentKey.add(g1);
            currentKey.add(g2);
            currentKey.add(g3);
        } else if (StringUtils.isNotBlank((CharSequence)g2) && !StringUtils.equals((CharSequence)g2, (CharSequence)"*")) {
            currentKey.add(g1);
            currentKey.add(g2);
        } else if (StringUtils.isNotBlank((CharSequence)g1) && !StringUtils.equals((CharSequence)g1, (CharSequence)"*")) {
            currentKey.add(g1);
        }
        return Joiner.on((char)'.').join((Iterable)currentKey);
    }

    @Nonnull
    @VisibleForTesting
    static String parentKey(@NonNull MeasurementPosition position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        String g1 = position.getGroupingElementLevel1();
        String g2 = position.getGroupingElementLevel2();
        String g3 = position.getGroupingElementLevel3();
        String g4 = position.getGroupingElementLevel4();
        EPositionType positionType = position.getPositionType();
        ArrayList currentKey = Lists.newArrayList();
        if (positionType == EPositionType.COMMENT) {
            if (StringUtils.isNotBlank((CharSequence)g1) && !StringUtils.equals((CharSequence)g1, (CharSequence)"*")) {
                currentKey.add(g1);
            }
            if (StringUtils.isNotBlank((CharSequence)g2) && !StringUtils.equals((CharSequence)g2, (CharSequence)"*")) {
                currentKey.add(g2);
            }
            if (StringUtils.isNotBlank((CharSequence)g3) && !StringUtils.equals((CharSequence)g3, (CharSequence)"*")) {
                currentKey.add(g3);
            }
            if (StringUtils.isNotBlank((CharSequence)g4) && !StringUtils.equals((CharSequence)g4, (CharSequence)"*")) {
                currentKey.add(g4);
            }
            if (!currentKey.isEmpty()) {
                currentKey.remove(currentKey.size() - 1);
            }
        } else if (Iterables.contains((Iterable)EPositionType.PRINTABLE_POSITIONS, (Object)positionType)) {
            if (StringUtils.isNotBlank((CharSequence)g1)) {
                currentKey.add(g1);
            }
            if (StringUtils.isNotBlank((CharSequence)g2)) {
                currentKey.add(g2);
            }
            if (StringUtils.isNotBlank((CharSequence)g3)) {
                currentKey.add(g3);
            }
            if (StringUtils.isNotBlank((CharSequence)g4)) {
                currentKey.add(g4);
            }
        }
        return Joiner.on((char)'.').join((Iterable)currentKey);
    }

    @Nonnull
    @VisibleForTesting
    static String parentKey(@NonNull String input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (input.contains(".")) {
            return StringUtils.substringBeforeLast((String)input, (String)".");
        }
        return "";
    }

    @Nonnull
    @VisibleForTesting
    static String standardKeys(@NonNull MeasurementPosition position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        String g1 = position.getGroupingElementLevel1();
        String g2 = position.getGroupingElementLevel2();
        String g3 = position.getGroupingElementLevel3();
        String g4 = position.getGroupingElementLevel4();
        EPositionType positionType = position.getPositionType();
        ArrayList currentKey = Lists.newArrayList();
        if (Iterables.contains((Iterable)EPositionType.PRINTABLE_POSITIONS, (Object)positionType)) {
            if (StringUtils.isNotBlank((CharSequence)g4)) {
                currentKey.add(g1);
                currentKey.add(g2);
                currentKey.add(g3);
                currentKey.add(g4);
            } else if (StringUtils.isNotBlank((CharSequence)g3)) {
                currentKey.add(g1);
                currentKey.add(g2);
                currentKey.add(g3);
            } else if (StringUtils.isNotBlank((CharSequence)g2)) {
                currentKey.add(g1);
                currentKey.add(g2);
            } else if (StringUtils.isNotBlank((CharSequence)g1)) {
                currentKey.add(g1);
            }
        }
        return Joiner.on((char)'.').join((Iterable)currentKey);
    }
}

