/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.helper;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import de.qfm.erp.service.model.internal.quotation.ER2InvoiceInputBucket;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceState;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceType;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.model.jpa.measurement.InvoiceMeasurement;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.quotation.EStageOrigin;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class InvoiceHelper {
    @Nonnull
    public static String costUnitDiamant(@NonNull ER2InvoiceInputBucket er2InvoiceInputBucket) {
        if (er2InvoiceInputBucket == null) {
            throw new NullPointerException("er2InvoiceInputBucket is marked non-null but is null");
        }
        String stageOrEntityNumberPrefix = er2InvoiceInputBucket.getStageOrEntityNumberPrefix();
        Invoice invoice = er2InvoiceInputBucket.getInvoice();
        Quotation quotation = invoice.getQuotation();
        String costUnit = quotation.getOrigin() == EStageOrigin.QUANTE_V2 ? StringUtils.removeStart((String)quotation.getQNumber(), (String)stageOrEntityNumberPrefix) : quotation.getQuotationNumber();
        return StringUtils.remove((String)costUnit, (String)"/");
    }

    @Nonnull
    public static String costUnitER2Invoice(@NonNull ER2InvoiceInputBucket er2InvoiceInputBucket) {
        if (er2InvoiceInputBucket == null) {
            throw new NullPointerException("er2InvoiceInputBucket is marked non-null but is null");
        }
        String stageOrEntityNumberPrefix = er2InvoiceInputBucket.getStageOrEntityNumberPrefix();
        Invoice invoice = er2InvoiceInputBucket.getInvoice();
        Quotation quotation = invoice.getQuotation();
        String costUnit = quotation.getOrigin() == EStageOrigin.QUANTE_V2 ? StringUtils.removeStart((String)quotation.getQNumber(), (String)stageOrEntityNumberPrefix) : quotation.getQuotationNumber();
        return StringUtils.remove((String)costUnit, (String)"/");
    }

    @Deprecated(forRemoval=true)
    @Nonnull
    public static String costUnitER2Invoice(@NonNull Invoice invoice) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        Quotation quotation = invoice.getQuotation();
        String costUnit = quotation.getOrigin() == EStageOrigin.QUANTE_V2 ? StringUtils.substring((String)quotation.getQNumber(), (int)1) : quotation.getQuotationNumber();
        return StringUtils.remove((String)costUnit, (String)"/");
    }

    @Nonnull
    public static String costUnitEnaio(@NonNull Invoice invoice, @NonNull String stageOrEntityNumberPrefix) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        if (stageOrEntityNumberPrefix == null) {
            throw new NullPointerException("stageOrEntityNumberPrefix is marked non-null but is null");
        }
        Quotation quotation = invoice.getQuotation();
        EStageOrigin origin = quotation.getOrigin();
        EInvoiceType invoiceType = invoice.getInvoiceType();
        String costUnit = invoiceType == EInvoiceType.CREDIT_VOUCHER ? invoice.getOrderDescription() : (origin == EStageOrigin.QUANTE_V1 ? StringUtils.trimToEmpty((String)quotation.getQuotationNumber()) : StringUtils.removeStart((String)quotation.getQNumber(), (String)stageOrEntityNumberPrefix));
        return StringUtils.remove((String)costUnit, (String)"/");
    }

    @Nonnull
    public static String costUnitPrint(@NonNull Invoice invoice) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        Quotation quotation = invoice.getQuotation();
        EStageOrigin origin = quotation.getOrigin();
        if (origin == EStageOrigin.QUANTE_V1) {
            return StringUtils.trimToEmpty((String)quotation.getQuotationNumber());
        }
        return StringUtils.trimToEmpty((String)quotation.getQNumber());
    }

    @Nonnull
    public static Iterable<Measurement> measurements(@NonNull Iterable<InvoiceMeasurement> invoiceMeasurements) {
        if (invoiceMeasurements == null) {
            throw new NullPointerException("invoiceMeasurements is marked non-null but is null");
        }
        return (Iterable)Streams.stream(invoiceMeasurements).map(InvoiceMeasurement::getMeasurement).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
    }

    @Nonnull
    public static LocalDate accountingDate(@NonNull Invoice invoice) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        EInvoiceState invoiceState = (EInvoiceState)MoreObjects.firstNonNull((Object)invoice.getInvoiceState(), (Object)EInvoiceState.UNKNOWN);
        if (EInvoiceState.CANCELLED == invoiceState) {
            return invoice.getCancellationDate();
        }
        return invoice.getInvoiceDate();
    }

    @Nonnull
    public static LocalDate postingDate(@NonNull Invoice invoice) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        EInvoiceState invoiceState = (EInvoiceState)MoreObjects.firstNonNull((Object)invoice.getInvoiceState(), (Object)EInvoiceState.UNKNOWN);
        if (EInvoiceState.CANCELLED == invoiceState) {
            return invoice.getCancellationPeriod();
        }
        return invoice.getPostingDate();
    }

    @Nonnull
    public static Optional<LocalDate> cashDiscountDate1(@NonNull Invoice invoice) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        return InvoiceHelper.cashDiscountDate((LocalDate)invoice.getInvoiceDate(), (Integer)invoice.getFinanceCashDiscountTime1());
    }

    @Nonnull
    public static Optional<LocalDate> cashDiscountDate2(@NonNull Invoice invoice) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        return InvoiceHelper.cashDiscountDate((LocalDate)invoice.getInvoiceDate(), (Integer)invoice.getFinanceCashDiscountTime2());
    }

    @Nonnull
    public static Optional<LocalDate> cashDiscountDate(@NonNull LocalDate invoiceDate, @Nullable Integer financeCashDiscountTime) {
        if (invoiceDate == null) {
            throw new NullPointerException("invoiceDate is marked non-null but is null");
        }
        int safeFinanceCashDiscountTime = (Integer)MoreObjects.firstNonNull((Object)financeCashDiscountTime, (Object)0);
        if (0 != safeFinanceCashDiscountTime) {
            return Optional.of(invoiceDate.plusDays(safeFinanceCashDiscountTime));
        }
        return Optional.empty();
    }
}

