/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.helper;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import de.qfm.erp.service.helper.InvoiceHelper;
import de.qfm.erp.service.helper.StageHelper;
import de.qfm.erp.service.model.internal.quotation.ER2InvoiceInputBucket;
import de.qfm.erp.service.model.internal.quotation.ER2StageInputBucket;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.quotation.EStageOrigin;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class ER2Helper {
    private static final Joiner COL_JOINER = Joiner.on((String)",").useForNull("");
    private static final Joiner ROW_JOINER = Joiner.on((String)"\n").useForNull("");

    @Nonnull
    public static String costUnit(@NonNull ER2StageInputBucket er2StageInputBucket) {
        if (er2StageInputBucket == null) {
            throw new NullPointerException("er2StageInputBucket is marked non-null but is null");
        }
        String stageOrEntityNumberPrefix = er2StageInputBucket.getStageOrEntityNumberPrefix();
        Quotation stage = er2StageInputBucket.getStage();
        String costUnit = StageHelper.costUnit((Quotation)stage);
        EStageOrigin origin = stage.getOrigin();
        if (origin == EStageOrigin.QUANTE_V1) {
            return StringUtils.removeStart((String)StringUtils.remove((String)costUnit, (String)"/"), (String)stageOrEntityNumberPrefix);
        }
        return StringUtils.removeStart((String)costUnit, (String)stageOrEntityNumberPrefix);
    }

    public static byte[] asBytes(@NonNull Iterable<Iterable<String>> rows) {
        if (rows == null) {
            throw new NullPointerException("rows is marked non-null but is null");
        }
        Iterable rowsAsString = (Iterable)Streams.stream(rows).map(arg_0 -> ((Joiner)COL_JOINER).join(arg_0)).collect(ImmutableList.toImmutableList());
        String allRowsAsString = ROW_JOINER.join(rowsAsString);
        return allRowsAsString.getBytes(StandardCharsets.ISO_8859_1);
    }

    @Nonnull
    public static String measurementNumbers(@NonNull ER2InvoiceInputBucket er2InvoiceInputBucket) {
        if (er2InvoiceInputBucket == null) {
            throw new NullPointerException("er2InvoiceInputBucket is marked non-null but is null");
        }
        Invoice invoice = er2InvoiceInputBucket.getInvoice();
        Iterable invoiceMeasurements = (Iterable)MoreObjects.firstNonNull((Object)invoice.getInvoiceMeasurements(), (Object)ImmutableSet.of());
        Iterable measurements = InvoiceHelper.measurements((Iterable)invoiceMeasurements);
        ImmutableSet measurementNumbers = (ImmutableSet)Streams.stream((Iterable)measurements).map(Measurement::getMeasurementNumber).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        return Joiner.on((String)"; ").join((Iterable)measurementNumbers);
    }
}

