/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.configuration.search;

import de.qfm.erp.service.configuration.search.SearchConfiguration;
import de.qfm.erp.service.service.job.IndexCommitJob;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
public class IndexCommitConfig {
    @Lazy
    private final SearchConfiguration searchConfiguration;
    @Lazy
    private final IndexCommitJob indexCommitJob;

    @Scheduled(initialDelayString="${scheduler.search.indexer.commit.ms}", fixedDelayString="${scheduler.search.indexer.commit.ms}")
    public void triggerIndexCommitAndRefresh() {
        if (!this.searchConfiguration.isSearchIndexerImmediateCommitEnabled()) {
            this.indexCommitJob.trigger();
        }
    }

    public IndexCommitConfig(SearchConfiguration searchConfiguration, IndexCommitJob indexCommitJob) {
        this.searchConfiguration = searchConfiguration;
        this.indexCommitJob = indexCommitJob;
    }
}

