/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.configuration;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.SpecVersion;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.List;
import org.springdoc.core.models.GroupedOpenApi;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"swagger.enabled"}, havingValue="true")
public class SwaggerConfig {
    @Bean
    public GroupedOpenApi api() {
        return GroupedOpenApi.builder().group("qfm-group").pathsToMatch(new String[]{"/**"}).build();
    }

    @Bean
    public OpenAPI springShopOpenAPI() {
        String securitySchemeName = "bearerAuth";
        return new OpenAPI().specVersion(SpecVersion.V31).info(new Info().title("QFM ERP Backend API").description("This is Standalone QFM/Quante Backend Service. Once you have successfully logged in and obtained the token, you should click on the right top button `Authorize` and introduce it with the prefix \"Bearer \".").version("1.0.0").contact(new Contact().name("Ralf Heyde").url("http://leancoders.de/").email("rh@leancoders.de"))).addSecurityItem(new SecurityRequirement().addList("bearerAuth", List.of("Authorization", "Header"))).components(new Components().addSecuritySchemes("bearerAuth", new SecurityScheme().name("bearerAuth").type(SecurityScheme.Type.HTTP).scheme("bearer").bearerFormat("JWT")));
    }
}

