/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.configuration;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.PostConstruct;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class StageConfig
implements InitializingBean {
    private static final Logger log = LogManager.getLogger(StageConfig.class);
    private static final Splitter FOLDERS_DEFAULT_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    @Value(value="${stage.files.enabled}")
    private boolean enabled;
    @Value(value="${stage.files.client.home.folder}")
    private String clientHomeFolder;
    @Value(value="${stage.files.server.home.folder}")
    private String serverHomeFolder;
    @Value(value="${stage.files.folders.all}")
    private String stageFilesFoldersAll;
    private Path serverHomeFolderPath;
    private Path clientHomeFolderPath;
    private Iterable<Path> stageFilesFoldersAllPaths;

    public void afterPropertiesSet() {
        Path serverHomeFolderPath = Path.of(this.serverHomeFolder, new String[0]);
        Path clientHomeFolderPath = Path.of(this.clientHomeFolder, new String[0]);
        if (!serverHomeFolderPath.toFile().exists()) {
            log.error("ERROR: Server Home Folder Path: {} for QEntity/Stage is not accessible", (Object)this.serverHomeFolder);
        }
        this.clientHomeFolderPath = clientHomeFolderPath;
        this.serverHomeFolderPath = serverHomeFolderPath;
        ImmutableSet uniqueFoldersAll = ImmutableSet.copyOf((Iterable)FOLDERS_DEFAULT_SPLITTER.split((CharSequence)this.stageFilesFoldersAll));
        this.stageFilesFoldersAllPaths = (Iterable)uniqueFoldersAll.stream().map(x$0 -> Path.of(x$0, new String[0])).collect(ImmutableSet.toImmutableSet());
    }

    @PostConstruct
    public void postConstruct() {
        log.info("Loaded StageConfig: {}", (Object)this);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getClientHomeFolder() {
        return this.clientHomeFolder;
    }

    public String getServerHomeFolder() {
        return this.serverHomeFolder;
    }

    public String getStageFilesFoldersAll() {
        return this.stageFilesFoldersAll;
    }

    public Path getServerHomeFolderPath() {
        return this.serverHomeFolderPath;
    }

    public Path getClientHomeFolderPath() {
        return this.clientHomeFolderPath;
    }

    public Iterable<Path> getStageFilesFoldersAllPaths() {
        return this.stageFilesFoldersAllPaths;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setClientHomeFolder(String clientHomeFolder) {
        this.clientHomeFolder = clientHomeFolder;
    }

    public void setServerHomeFolder(String serverHomeFolder) {
        this.serverHomeFolder = serverHomeFolder;
    }

    public void setStageFilesFoldersAll(String stageFilesFoldersAll) {
        this.stageFilesFoldersAll = stageFilesFoldersAll;
    }

    public void setServerHomeFolderPath(Path serverHomeFolderPath) {
        this.serverHomeFolderPath = serverHomeFolderPath;
    }

    public void setClientHomeFolderPath(Path clientHomeFolderPath) {
        this.clientHomeFolderPath = clientHomeFolderPath;
    }

    public void setStageFilesFoldersAllPaths(Iterable<Path> stageFilesFoldersAllPaths) {
        this.stageFilesFoldersAllPaths = stageFilesFoldersAllPaths;
    }

    public String toString() {
        return "StageConfig(enabled=" + this.isEnabled() + ", clientHomeFolder=" + this.getClientHomeFolder() + ", serverHomeFolder=" + this.getServerHomeFolder() + ", stageFilesFoldersAll=" + this.getStageFilesFoldersAll() + ", serverHomeFolderPath=" + String.valueOf(this.getServerHomeFolderPath()) + ", clientHomeFolderPath=" + String.valueOf(this.getClientHomeFolderPath()) + ", stageFilesFoldersAllPaths=" + String.valueOf(this.getStageFilesFoldersAllPaths()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StageConfig)) {
            return false;
        }
        StageConfig other = (StageConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        String this$clientHomeFolder = this.getClientHomeFolder();
        String other$clientHomeFolder = other.getClientHomeFolder();
        if (this$clientHomeFolder == null ? other$clientHomeFolder != null : !this$clientHomeFolder.equals(other$clientHomeFolder)) {
            return false;
        }
        String this$serverHomeFolder = this.getServerHomeFolder();
        String other$serverHomeFolder = other.getServerHomeFolder();
        if (this$serverHomeFolder == null ? other$serverHomeFolder != null : !this$serverHomeFolder.equals(other$serverHomeFolder)) {
            return false;
        }
        String this$stageFilesFoldersAll = this.getStageFilesFoldersAll();
        String other$stageFilesFoldersAll = other.getStageFilesFoldersAll();
        if (this$stageFilesFoldersAll == null ? other$stageFilesFoldersAll != null : !this$stageFilesFoldersAll.equals(other$stageFilesFoldersAll)) {
            return false;
        }
        Path this$serverHomeFolderPath = this.getServerHomeFolderPath();
        Path other$serverHomeFolderPath = other.getServerHomeFolderPath();
        if (this$serverHomeFolderPath == null ? other$serverHomeFolderPath != null : !((Object)this$serverHomeFolderPath).equals(other$serverHomeFolderPath)) {
            return false;
        }
        Path this$clientHomeFolderPath = this.getClientHomeFolderPath();
        Path other$clientHomeFolderPath = other.getClientHomeFolderPath();
        if (this$clientHomeFolderPath == null ? other$clientHomeFolderPath != null : !((Object)this$clientHomeFolderPath).equals(other$clientHomeFolderPath)) {
            return false;
        }
        Iterable this$stageFilesFoldersAllPaths = this.getStageFilesFoldersAllPaths();
        Iterable other$stageFilesFoldersAllPaths = other.getStageFilesFoldersAllPaths();
        return !(this$stageFilesFoldersAllPaths == null ? other$stageFilesFoldersAllPaths != null : !this$stageFilesFoldersAllPaths.equals(other$stageFilesFoldersAllPaths));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StageConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        String $clientHomeFolder = this.getClientHomeFolder();
        result = result * 59 + ($clientHomeFolder == null ? 43 : $clientHomeFolder.hashCode());
        String $serverHomeFolder = this.getServerHomeFolder();
        result = result * 59 + ($serverHomeFolder == null ? 43 : $serverHomeFolder.hashCode());
        String $stageFilesFoldersAll = this.getStageFilesFoldersAll();
        result = result * 59 + ($stageFilesFoldersAll == null ? 43 : $stageFilesFoldersAll.hashCode());
        Path $serverHomeFolderPath = this.getServerHomeFolderPath();
        result = result * 59 + ($serverHomeFolderPath == null ? 43 : ((Object)$serverHomeFolderPath).hashCode());
        Path $clientHomeFolderPath = this.getClientHomeFolderPath();
        result = result * 59 + ($clientHomeFolderPath == null ? 43 : ((Object)$clientHomeFolderPath).hashCode());
        Iterable $stageFilesFoldersAllPaths = this.getStageFilesFoldersAllPaths();
        result = result * 59 + ($stageFilesFoldersAllPaths == null ? 43 : $stageFilesFoldersAllPaths.hashCode());
        return result;
    }
}

