/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.configuration;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import jakarta.annotation.PostConstruct;
import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class NodeConfig
implements InitializingBean {
    private static final Logger log = LogManager.getLogger(NodeConfig.class);
    public static final String RECENT_MEASUREMENT_IDS_CACHE = "recent_measurement_ids_cache";
    @Value(value="${node.name}")
    private String nodeName;
    @Value(value="${sync.overlap.seconds}")
    private int syncOverlapSeconds;
    @Value(value="${sync.batch.size}")
    private int syncBatchSize;

    @Bean(name={"recent_measurement_ids_cache"})
    public Cache<Long, LocalDateTime> recentIdsCache() {
        return CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite((long)this.syncOverlapSeconds, TimeUnit.SECONDS).build();
    }

    public void afterPropertiesSet() {
    }

    @PostConstruct
    public void postConstruct() {
        log.info("Loaded NodeConfiguration: {}", (Object)this);
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public int getSyncOverlapSeconds() {
        return this.syncOverlapSeconds;
    }

    public int getSyncBatchSize() {
        return this.syncBatchSize;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public void setSyncOverlapSeconds(int syncOverlapSeconds) {
        this.syncOverlapSeconds = syncOverlapSeconds;
    }

    public void setSyncBatchSize(int syncBatchSize) {
        this.syncBatchSize = syncBatchSize;
    }

    public String toString() {
        return "NodeConfig(nodeName=" + this.getNodeName() + ", syncOverlapSeconds=" + this.getSyncOverlapSeconds() + ", syncBatchSize=" + this.getSyncBatchSize() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NodeConfig)) {
            return false;
        }
        NodeConfig other = (NodeConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getSyncOverlapSeconds() != other.getSyncOverlapSeconds()) {
            return false;
        }
        if (this.getSyncBatchSize() != other.getSyncBatchSize()) {
            return false;
        }
        String this$nodeName = this.getNodeName();
        String other$nodeName = other.getNodeName();
        return !(this$nodeName == null ? other$nodeName != null : !this$nodeName.equals(other$nodeName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NodeConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSyncOverlapSeconds();
        result = result * 59 + this.getSyncBatchSize();
        String $nodeName = this.getNodeName();
        result = result * 59 + ($nodeName == null ? 43 : $nodeName.hashCode());
        return result;
    }
}

