/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.configuration;

import jakarta.annotation.PostConstruct;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.core.io.support.PropertySourceFactory;

@Configuration
@PropertySources(value={@PropertySource(value={"file:./enaio-config.properties"}, ignoreResourceNotFound=true, factory=PropertySourceFactory.class), @PropertySource(value={"${PROPERTIES_PATH}/enaio-config.properties"}, ignoreResourceNotFound=true, factory=PropertySourceFactory.class), @PropertySource(value={"file:/var/www/html/qfm-web-api/enaio-config.properties"}, ignoreResourceNotFound=true, factory=PropertySourceFactory.class)})
public class EnaioConfig
implements InitializingBean {
    private static final Logger log = LogManager.getLogger(EnaioConfig.class);
    @Value(value="${enaio.enabled:true}")
    private boolean enabled;
    @Value(value="${enaio.standard.folder:}")
    private String folderStandard;
    @Value(value="${enaio.credit_voucher.folder:}")
    private String folderCreditVoucher;
    @Value(value="${enaio.company_group.copy.enabled:true}")
    private boolean companyGroupCopyEnabled;
    @Value(value="${enaio.company_group.copy.folder:}")
    private String folderCompanyGroupCopy;
    private Path folderPathStandard;
    private Path folderPathCreditVoucher;
    private Path folderPathCompanyGroupCopy;

    public void afterPropertiesSet() {
        Path pathStandard = Path.of(this.folderStandard, new String[0]);
        if (!pathStandard.toFile().exists()) {
            log.error("ERROR: Path: {} for ENAIO is not accessible", (Object)this.folderStandard);
        }
        this.folderPathStandard = pathStandard;
        Path pathCreditVoucher = Path.of(this.folderCreditVoucher, new String[0]);
        if (!pathCreditVoucher.toFile().exists()) {
            log.error("ERROR: Path: {} for ENAIO is not accessible", (Object)this.folderCreditVoucher);
        }
        this.folderPathCreditVoucher = pathCreditVoucher;
        Path pathCompanyGroup = Path.of(this.folderCompanyGroupCopy, new String[0]);
        if (!pathCompanyGroup.toFile().exists()) {
            log.error("ERROR: Path: {} for ENAIO is not accessible", (Object)this.folderCompanyGroupCopy);
        }
        this.folderPathCompanyGroupCopy = pathCompanyGroup;
    }

    @PostConstruct
    public void postConstruct() {
        log.info("Loaded EnaioConfig: {}", (Object)this);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getFolderStandard() {
        return this.folderStandard;
    }

    public String getFolderCreditVoucher() {
        return this.folderCreditVoucher;
    }

    public boolean isCompanyGroupCopyEnabled() {
        return this.companyGroupCopyEnabled;
    }

    public String getFolderCompanyGroupCopy() {
        return this.folderCompanyGroupCopy;
    }

    public Path getFolderPathStandard() {
        return this.folderPathStandard;
    }

    public Path getFolderPathCreditVoucher() {
        return this.folderPathCreditVoucher;
    }

    public Path getFolderPathCompanyGroupCopy() {
        return this.folderPathCompanyGroupCopy;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setFolderStandard(String folderStandard) {
        this.folderStandard = folderStandard;
    }

    public void setFolderCreditVoucher(String folderCreditVoucher) {
        this.folderCreditVoucher = folderCreditVoucher;
    }

    public void setCompanyGroupCopyEnabled(boolean companyGroupCopyEnabled) {
        this.companyGroupCopyEnabled = companyGroupCopyEnabled;
    }

    public void setFolderCompanyGroupCopy(String folderCompanyGroupCopy) {
        this.folderCompanyGroupCopy = folderCompanyGroupCopy;
    }

    public void setFolderPathStandard(Path folderPathStandard) {
        this.folderPathStandard = folderPathStandard;
    }

    public void setFolderPathCreditVoucher(Path folderPathCreditVoucher) {
        this.folderPathCreditVoucher = folderPathCreditVoucher;
    }

    public void setFolderPathCompanyGroupCopy(Path folderPathCompanyGroupCopy) {
        this.folderPathCompanyGroupCopy = folderPathCompanyGroupCopy;
    }

    public String toString() {
        return "EnaioConfig(enabled=" + this.isEnabled() + ", folderStandard=" + this.getFolderStandard() + ", folderCreditVoucher=" + this.getFolderCreditVoucher() + ", companyGroupCopyEnabled=" + this.isCompanyGroupCopyEnabled() + ", folderCompanyGroupCopy=" + this.getFolderCompanyGroupCopy() + ", folderPathStandard=" + String.valueOf(this.getFolderPathStandard()) + ", folderPathCreditVoucher=" + String.valueOf(this.getFolderPathCreditVoucher()) + ", folderPathCompanyGroupCopy=" + String.valueOf(this.getFolderPathCompanyGroupCopy()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnaioConfig)) {
            return false;
        }
        EnaioConfig other = (EnaioConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isCompanyGroupCopyEnabled() != other.isCompanyGroupCopyEnabled()) {
            return false;
        }
        String this$folderStandard = this.getFolderStandard();
        String other$folderStandard = other.getFolderStandard();
        if (this$folderStandard == null ? other$folderStandard != null : !this$folderStandard.equals(other$folderStandard)) {
            return false;
        }
        String this$folderCreditVoucher = this.getFolderCreditVoucher();
        String other$folderCreditVoucher = other.getFolderCreditVoucher();
        if (this$folderCreditVoucher == null ? other$folderCreditVoucher != null : !this$folderCreditVoucher.equals(other$folderCreditVoucher)) {
            return false;
        }
        String this$folderCompanyGroupCopy = this.getFolderCompanyGroupCopy();
        String other$folderCompanyGroupCopy = other.getFolderCompanyGroupCopy();
        if (this$folderCompanyGroupCopy == null ? other$folderCompanyGroupCopy != null : !this$folderCompanyGroupCopy.equals(other$folderCompanyGroupCopy)) {
            return false;
        }
        Path this$folderPathStandard = this.getFolderPathStandard();
        Path other$folderPathStandard = other.getFolderPathStandard();
        if (this$folderPathStandard == null ? other$folderPathStandard != null : !((Object)this$folderPathStandard).equals(other$folderPathStandard)) {
            return false;
        }
        Path this$folderPathCreditVoucher = this.getFolderPathCreditVoucher();
        Path other$folderPathCreditVoucher = other.getFolderPathCreditVoucher();
        if (this$folderPathCreditVoucher == null ? other$folderPathCreditVoucher != null : !((Object)this$folderPathCreditVoucher).equals(other$folderPathCreditVoucher)) {
            return false;
        }
        Path this$folderPathCompanyGroupCopy = this.getFolderPathCompanyGroupCopy();
        Path other$folderPathCompanyGroupCopy = other.getFolderPathCompanyGroupCopy();
        return !(this$folderPathCompanyGroupCopy == null ? other$folderPathCompanyGroupCopy != null : !((Object)this$folderPathCompanyGroupCopy).equals(other$folderPathCompanyGroupCopy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EnaioConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isCompanyGroupCopyEnabled() ? 79 : 97);
        String $folderStandard = this.getFolderStandard();
        result = result * 59 + ($folderStandard == null ? 43 : $folderStandard.hashCode());
        String $folderCreditVoucher = this.getFolderCreditVoucher();
        result = result * 59 + ($folderCreditVoucher == null ? 43 : $folderCreditVoucher.hashCode());
        String $folderCompanyGroupCopy = this.getFolderCompanyGroupCopy();
        result = result * 59 + ($folderCompanyGroupCopy == null ? 43 : $folderCompanyGroupCopy.hashCode());
        Path $folderPathStandard = this.getFolderPathStandard();
        result = result * 59 + ($folderPathStandard == null ? 43 : ((Object)$folderPathStandard).hashCode());
        Path $folderPathCreditVoucher = this.getFolderPathCreditVoucher();
        result = result * 59 + ($folderPathCreditVoucher == null ? 43 : ((Object)$folderPathCreditVoucher).hashCode());
        Path $folderPathCompanyGroupCopy = this.getFolderPathCompanyGroupCopy();
        result = result * 59 + ($folderPathCompanyGroupCopy == null ? 43 : ((Object)$folderPathCompanyGroupCopy).hashCode());
        return result;
    }
}

