/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.configuration;

import de.qfm.erp.service.configuration.search.IndexCommitConfig;
import de.qfm.erp.service.configuration.search.LuceneConfiguration;
import de.qfm.erp.service.configuration.search.LuceneRealTimeThreadConfiguration;
import de.qfm.erp.service.configuration.search.SearchConfiguration;
import de.qfm.erp.service.service.job.DirtySearchIndexRefreshJob;
import de.qfm.erp.service.service.route.impl.CustomerSearchRoute;
import de.qfm.erp.service.service.route.impl.EntitySearchRoute;
import de.qfm.erp.service.service.route.impl.InvoiceSearchRoute;
import de.qfm.erp.service.service.route.impl.MeasurementSearchRoute;
import de.qfm.erp.service.service.route.impl.StageSearchRoute;
import de.qfm.erp.service.service.route.impl.SubProjectSearchRoute;
import de.qfm.erp.service.service.route.impl.UserSearchRoute;
import de.qfm.erp.service.service.security.UserService;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@EnableScheduling
@Import(value={LuceneConfiguration.class, LuceneRealTimeThreadConfiguration.class, IndexCommitConfig.class, SearchConfiguration.class})
public class EnabledSearchConfig {
    private static final Logger log = LogManager.getLogger(EnabledSearchConfig.class);
    private final UserService userService;

    @ConditionalOnProperty(value={"scheduler.enabled"}, havingValue="true")
    @Bean
    public DirtySearchIndexRefreshJob dirtyMeasurementRefreshJob(@NonNull CustomerSearchRoute customerSearchRoute, @NonNull EntitySearchRoute entitySearchRoute, @NonNull InvoiceSearchRoute invoiceSearchRoute, @NonNull MeasurementSearchRoute measurementSearchRoute, @NonNull StageSearchRoute stageSearchRoute, @NonNull SubProjectSearchRoute subProjectSearchRoute, @NonNull UserSearchRoute userSearchRoute) {
        if (customerSearchRoute == null) {
            throw new NullPointerException("customerSearchRoute is marked non-null but is null");
        }
        if (entitySearchRoute == null) {
            throw new NullPointerException("entitySearchRoute is marked non-null but is null");
        }
        if (invoiceSearchRoute == null) {
            throw new NullPointerException("invoiceSearchRoute is marked non-null but is null");
        }
        if (measurementSearchRoute == null) {
            throw new NullPointerException("measurementSearchRoute is marked non-null but is null");
        }
        if (stageSearchRoute == null) {
            throw new NullPointerException("stageSearchRoute is marked non-null but is null");
        }
        if (subProjectSearchRoute == null) {
            throw new NullPointerException("subProjectSearchRoute is marked non-null but is null");
        }
        if (userSearchRoute == null) {
            throw new NullPointerException("userSearchRoute is marked non-null but is null");
        }
        return new DirtySearchIndexRefreshJob(customerSearchRoute, entitySearchRoute, invoiceSearchRoute, measurementSearchRoute, stageSearchRoute, subProjectSearchRoute, userSearchRoute);
    }

    public EnabledSearchConfig(UserService userService) {
        this.userService = userService;
    }

    public UserService getUserService() {
        return this.userService;
    }
}

